/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.iam.IAM2ComponentVerifierExtension;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.iam.IamClient;

@org.apache.camel.spi.annotations.Component(value="aws2-iam")
public class IAM2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private IAM2Configuration configuration;

    public IAM2Component() {
        this(null);
    }

    public IAM2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new IAM2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IAM2Configuration configuration = this.configuration != null ? this.configuration.copy() : new IAM2Configuration();
        IAM2Endpoint endpoint = new IAM2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getIamClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon IAM client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public IAM2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAM2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(IAM2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(IamClient.class);
        if (clients.size() == 1) {
            configuration.setIamClient((IamClient)clients.stream().findFirst().get());
        }
    }
}

