/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Constants;
import org.apache.camel.component.aws2.iam.IAM2Producer;
import org.apache.camel.component.aws2.iam.client.IAM2ClientFactory;
import org.apache.camel.component.aws2.iam.client.IAM2HealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.iam.IamClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-iam", title="AWS Identity and Access Management (IAM)", syntax="aws2-iam:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=IAM2Constants.class)
public class IAM2Endpoint
extends ScheduledPollEndpoint {
    private IamClient iamClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private IAM2HealthCheck clientHealthCheck;
    @UriParam
    private IAM2Configuration configuration;

    public IAM2Endpoint(String uri, Component component, IAM2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new IAM2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.iamClient = this.configuration.getIamClient() != null ? this.configuration.getIamClient() : IAM2ClientFactory.getIamClient(this.configuration).getIamClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new IAM2HealthCheck(this, this.getId());
        }
        this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getIamClient()) && this.iamClient != null) {
            this.iamClient.close();
        }
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        super.doStop();
    }

    public IAM2Configuration getConfiguration() {
        return this.configuration;
    }

    public IamClient getIamClient() {
        return this.iamClient;
    }
}

