/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.consumer;

import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeStrategy;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class KinesisUserConfigurationResumeStrategy
implements KinesisResumeStrategy {
    private final Kinesis2Configuration configuration;

    public KinesisUserConfigurationResumeStrategy(Kinesis2Configuration configuration) {
        this.configuration = configuration;
    }

    private boolean hasSequenceNumber() {
        return !this.configuration.getSequenceNumber().isEmpty() && (this.configuration.getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.configuration.getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER));
    }

    public void resume(GetShardIteratorRequest.Builder resumable) {
        if (this.hasSequenceNumber()) {
            resumable.startingSequenceNumber(this.configuration.getSequenceNumber());
        }
    }
}

