/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.consumer;

import java.nio.ByteBuffer;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisOffset;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeAdapter;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.cache.ResumeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class KinesisDefaultResumeAdapter
implements KinesisResumeAdapter,
Cacheable,
Deserializable {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisDefaultResumeAdapter.class);
    private ResumeCache<String> cache;
    private GetShardIteratorRequest.Builder resumable;
    private String streamName;

    @Override
    public void setRequestBuilder(GetShardIteratorRequest.Builder resumable) {
        this.resumable = resumable;
    }

    public void resume() {
        assert (this.streamName != null);
        assert (this.resumable != null);
        KinesisOffset offset = (KinesisOffset)this.cache.get((Object)this.streamName, KinesisOffset.class);
        if (offset == null) {
            LOG.info("There is no offset for the stream {}", (Object)this.streamName);
            return;
        }
        String sequenceNumber = offset.getValue();
        LOG.info("Resuming from offset {} for key {}", (Object)sequenceNumber, (Object)this.streamName);
        this.resumable.shardIteratorType(ShardIteratorType.AFTER_SEQUENCE_NUMBER);
        this.resumable.startingSequenceNumber(sequenceNumber);
    }

    private void add(Object key, Object offset) {
        KinesisOffset ko = (KinesisOffset)this.cache.computeIfAbsent((Object)((String)key), k -> new KinesisOffset());
        ko.update((String)offset);
    }

    public boolean add(OffsetKey<?> key, Offset<?> offset) {
        this.add(key.getValue(), offset.getValue());
        return true;
    }

    public void setCache(ResumeCache<?> cache) {
        this.cache = cache;
    }

    public ResumeCache<?> getCache() {
        return this.cache;
    }

    public boolean deserialize(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        Object keyObj = this.deserializeObject(keyBuffer);
        Object valueObj = this.deserializeObject(valueBuffer);
        this.add(keyObj, valueObj);
        return true;
    }

    @Override
    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }
}

