/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.Map;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Consumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;

public class Kinesis2ConsumerHealthCheck
extends AbstractHealthCheck {
    private final Kinesis2Consumer kinesis2Consumer;
    private final String routeId;

    public Kinesis2ConsumerHealthCheck(Kinesis2Consumer kinesis2Consumer, String routeId) {
        super("camel", "aws2-kinesis-consumer-" + routeId);
        this.kinesis2Consumer = kinesis2Consumer;
        this.routeId = routeId;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            KinesisClient client;
            Kinesis2Configuration configuration = this.kinesis2Consumer.getConfiguration();
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !KinesisClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            if (!configuration.isUseDefaultCredentialsProvider()) {
                AwsBasicCredentials cred = AwsBasicCredentials.create((String)configuration.getAccessKey(), (String)configuration.getSecretKey());
                KinesisClientBuilder clientBuilder = KinesisClient.builder();
                client = (KinesisClient)((KinesisClientBuilder)((KinesisClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred))).region(Region.of((String)configuration.getRegion()))).build();
            } else if (ObjectHelper.isNotEmpty((Object)configuration.getAmazonKinesisClient())) {
                client = configuration.getAmazonKinesisClient();
            } else {
                KinesisClientBuilder clientBuilder = KinesisClient.builder();
                client = (KinesisClient)((KinesisClientBuilder)clientBuilder.region(Region.of((String)configuration.getRegion()))).build();
            }
            client.listStreams();
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

