/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2ShardClosedStrategyEnum;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class Kinesis2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Kinesis2Configuration getOrCreateConfiguration(Kinesis2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Kinesis2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Kinesis2Component target = (Kinesis2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisclient": 
            case "amazonKinesisClient": {
                this.getOrCreateConfiguration(target).setAmazonKinesisClient((KinesisClient)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, KinesisClient.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Kinesis2Configuration)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Kinesis2Configuration.class, (Object)value));
                return true;
            }
            case "iteratortype": 
            case "iteratorType": {
                this.getOrCreateConfiguration(target).setIteratorType((ShardIteratorType)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                this.getOrCreateConfiguration(target).setMaxResultsPerRequest((Integer)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumber": 
            case "sequenceNumber": {
                this.getOrCreateConfiguration(target).setSequenceNumber((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shardclosed": 
            case "shardClosed": {
                this.getOrCreateConfiguration(target).setShardClosed((Kinesis2ShardClosedStrategyEnum)((Object)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, Kinesis2ShardClosedStrategyEnum.class, (Object)value)));
                return true;
            }
            case "shardid": 
            case "shardId": {
                this.getOrCreateConfiguration(target).setShardId((String)Kinesis2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonKinesisClient", KinesisClient.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("configuration", Kinesis2Configuration.class);
        answer.put("iteratorType", ShardIteratorType.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maxResultsPerRequest", Integer.TYPE);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("sequenceNumber", String.class);
        answer.put("shardClosed", Kinesis2ShardClosedStrategyEnum.class);
        answer.put("shardId", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Kinesis2Component target = (Kinesis2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonkinesisclient": 
            case "amazonKinesisClient": {
                return this.getOrCreateConfiguration(target).getAmazonKinesisClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "iteratortype": 
            case "iteratorType": {
                return this.getOrCreateConfiguration(target).getIteratorType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "sequencenumber": 
            case "sequenceNumber": {
                return this.getOrCreateConfiguration(target).getSequenceNumber();
            }
            case "shardclosed": 
            case "shardClosed": {
                return this.getOrCreateConfiguration(target).getShardClosed();
            }
            case "shardid": 
            case "shardId": {
                return this.getOrCreateConfiguration(target).getShardId();
            }
        }
        return null;
    }
}

