/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Consumer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-kinesis", title="AWS 2 Kinesis", syntax="aws2-kinesis:streamName", category={Category.CLOUD, Category.MESSAGING})
public class Kinesis2Endpoint
extends ScheduledPollEndpoint {
    @UriParam
    private Kinesis2Configuration configuration;
    private KinesisClient kinesisClient;

    public Kinesis2Endpoint(String uri, Kinesis2Configuration configuration, Kinesis2Component component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        KinesisClient kinesisClient = this.kinesisClient = this.configuration.getAmazonKinesisClient() != null ? this.configuration.getAmazonKinesisClient() : this.createKinesisClient();
        if ((this.configuration.getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.configuration.getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) && this.configuration.getSequenceNumber().isEmpty()) {
            throw new IllegalArgumentException("Sequence Number must be specified with iterator Types AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER");
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisClient()) && this.kinesisClient != null) {
            this.kinesisClient.close();
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new Kinesis2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Kinesis2Consumer consumer = new Kinesis2Consumer(this, processor);
        consumer.setSchedulerProperties(this.getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Record record) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setBody((Object)record);
        exchange.getIn().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)record.approximateArrivalTimestamp());
        exchange.getIn().setHeader("CamelAwsKinesisPartitionKey", (Object)record.partitionKey());
        exchange.getIn().setHeader("CamelAwsKinesisSequenceNumber", (Object)record.sequenceNumber());
        return exchange;
    }

    public KinesisClient getClient() {
        return this.kinesisClient;
    }

    public Kinesis2Configuration getConfiguration() {
        return this.configuration;
    }

    KinesisClient createKinesisClient() {
        KinesisClient client = null;
        KinesisClientBuilder clientBuilder = KinesisClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (KinesisClientBuilder)((KinesisClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (KinesisClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (KinesisClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (KinesisClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (KinesisClient)clientBuilder.build();
        return client;
    }
}

