/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Component;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.firehose.FirehoseClient;

public class KinesisFirehose2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private KinesisFirehose2Configuration getOrCreateConfiguration(KinesisFirehose2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KinesisFirehose2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KinesisFirehose2Component target = (KinesisFirehose2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                this.getOrCreateConfiguration(target).setAmazonKinesisFirehoseClient((FirehoseClient)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, FirehoseClient.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cborenabled": 
            case "cborEnabled": {
                this.getOrCreateConfiguration(target).setCborEnabled((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KinesisFirehose2Configuration)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, KinesisFirehose2Configuration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((KinesisFirehose2Operations)((Object)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, KinesisFirehose2Operations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KinesisFirehose2Component target = (KinesisFirehose2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                return this.getOrCreateConfiguration(target).getAmazonKinesisFirehoseClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "cborenabled": 
            case "cborEnabled": {
                return this.getOrCreateConfiguration(target).isCborEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("amazonKinesisFirehoseClient", FirehoseClient.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("cborEnabled", Boolean.TYPE);
        map.put("configuration", KinesisFirehose2Configuration.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("operation", KinesisFirehose2Operations.class);
        map.put("proxyHost", String.class);
        map.put("proxyPort", Integer.class);
        map.put("proxyProtocol", Protocol.class);
        map.put("region", String.class);
        map.put("trustAllCertificates", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("accessKey", String.class);
        map.put("secretKey", String.class);
        ALL_OPTIONS = map;
    }
}

