/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.firehose.FirehoseClient;

@UriParams
public class KinesisFirehose2Configuration
implements Cloneable {
    @UriPath(description="Name of the stream")
    @Metadata(required=true)
    private String streamName;
    @UriParam(label="security", secret=true, description="Amazon AWS Access Key")
    private String accessKey;
    @UriParam(label="security", secret=true, description="Amazon AWS Secret Key")
    private String secretKey;
    @UriParam(description="The region in which Kinesis Firehose client needs to work. When using this parameter, the configuration will expect the lowercase name of the region (for example ap-east-1) You'll need to use the name Region.EU_WEST_1.id()")
    private String region;
    @UriParam(description="Amazon Kinesis Firehose client to use for all requests for this endpoint")
    private FirehoseClient amazonKinesisFirehoseClient;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS", description="To define a proxy protocol when instantiating the Kinesis Firehose client")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(description="To define a proxy host when instantiating the Kinesis Firehose client")
    private String proxyHost;
    @UriParam(description="To define a proxy port when instantiating the Kinesis Firehose client")
    private Integer proxyPort;
    @UriParam(label="producer", description="The operation to do in case the user don't want to send only a record")
    private KinesisFirehose2Operations operation;
    @UriParam(defaultValue="false", description="If we want to trust all certificates in case of overriding the endpoint")
    private boolean trustAllCertificates;
    @UriParam(label="common", defaultValue="true", description="Setting the autoDiscoverClient mechanism, if true, the component will  look for a client instance in the registry automatically otherwise it will skip that checking")
    private boolean autoDiscoverClient = true;
    @UriParam(label="common", defaultValue="true", description="This option will set the CBOR_ENABLED property during the execution")
    private boolean cborEnabled = true;

    public void setAmazonKinesisFirehoseClient(FirehoseClient client) {
        this.amazonKinesisFirehoseClient = client;
    }

    public FirehoseClient getAmazonKinesisFirehoseClient() {
        return this.amazonKinesisFirehoseClient;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public KinesisFirehose2Operations getOperation() {
        return this.operation;
    }

    public void setOperation(KinesisFirehose2Operations operation) {
        this.operation = operation;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public boolean isCborEnabled() {
        return this.cborEnabled;
    }

    public void setCborEnabled(boolean cborEnabled) {
        this.cborEnabled = cborEnabled;
    }

    public KinesisFirehose2Configuration copy() {
        try {
            return (KinesisFirehose2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

