/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Component;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.firehose.FirehoseClient;

public class KinesisFirehose2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private KinesisFirehose2Configuration getOrCreateConfiguration(KinesisFirehose2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KinesisFirehose2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KinesisFirehose2Component target = (KinesisFirehose2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                this.getOrCreateConfiguration(target).setAmazonKinesisFirehoseClient((FirehoseClient)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, FirehoseClient.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cborenabled": 
            case "cborEnabled": {
                this.getOrCreateConfiguration(target).setCborEnabled((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KinesisFirehose2Configuration)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, KinesisFirehose2Configuration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((KinesisFirehose2Operations)((Object)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, KinesisFirehose2Operations.class, (Object)value)));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)KinesisFirehose2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"amazonKinesisFirehoseClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                return FirehoseClient.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "cborenabled": 
            case "cborEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return KinesisFirehose2Configuration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return KinesisFirehose2Operations.class;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KinesisFirehose2Component target = (KinesisFirehose2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                return this.getOrCreateConfiguration(target).getAmazonKinesisFirehoseClient();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "cborenabled": 
            case "cborEnabled": {
                return this.getOrCreateConfiguration(target).isCborEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
        }
        return null;
    }
}

