/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.component.aws2.kinesis.KinesisConnection;
import org.apache.camel.component.aws2.kinesis.ReachedClosedStatusException;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class Kinesis2Consumer
extends ScheduledBatchPollingConsumer
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(Kinesis2Consumer.class);
    private KinesisConnection connection;
    private ResumeStrategy resumeStrategy;
    private Map<String, String> currentShardIterators = new HashMap<String, String>();

    public Kinesis2Consumer(Kinesis2Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public KinesisConnection getConnection() {
        return this.connection;
    }

    public void setConnection(KinesisConnection connection) {
        this.connection = connection;
    }

    protected int poll() throws Exception {
        AtomicInteger processedExchangeCount = new AtomicInteger(0);
        if (!this.getEndpoint().getConfiguration().getShardId().isEmpty()) {
            DescribeStreamResponse response;
            DescribeStreamRequest request = (DescribeStreamRequest)DescribeStreamRequest.builder().streamName(this.getEndpoint().getConfiguration().getStreamName()).build();
            if (this.getEndpoint().getConfiguration().isAsyncClient()) {
                try {
                    response = (DescribeStreamResponse)this.connection.getAsyncClient(this.getEndpoint()).describeStream(request).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                response = this.connection.getClient(this.getEndpoint()).describeStream(request);
            }
            Shard shard2 = response.streamDescription().shards().stream().filter(shardItem -> shardItem.shardId().equalsIgnoreCase(this.getEndpoint().getConfiguration().getShardId())).findFirst().orElseThrow(() -> new IllegalStateException("The shard can't be found"));
            this.fetchAndPrepareRecordsForCamel(shard2, this.connection, processedExchangeCount);
        } else {
            this.getShardList(this.connection).parallelStream().forEach(shard -> this.fetchAndPrepareRecordsForCamel((Shard)shard, this.connection, processedExchangeCount));
        }
        return processedExchangeCount.get();
    }

    private void fetchAndPrepareRecordsForCamel(Shard shard, KinesisConnection kinesisConnection, AtomicInteger processedExchangeCount) {
        GetRecordsResponse result;
        String shardIterator;
        try {
            shardIterator = this.getShardIterator(shard, kinesisConnection);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (shardIterator == null) {
            processedExchangeCount.set(0);
            return;
        }
        GetRecordsRequest req = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(shardIterator).limit(Integer.valueOf(this.getEndpoint().getConfiguration().getMaxResultsPerRequest())).build();
        if (this.getEndpoint().getConfiguration().isAsyncClient()) {
            try {
                result = (GetRecordsResponse)kinesisConnection.getAsyncClient(this.getEndpoint()).getRecords(req).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            result = kinesisConnection.getClient(this.getEndpoint()).getRecords(req);
        }
        try {
            Queue<Exchange> exchanges = this.createExchanges(result.records());
            processedExchangeCount.getAndSet(this.processBatch(CastUtils.cast(exchanges)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateShardIterator(shard, result.nextShardIterator());
    }

    private void updateShardIterator(Shard shard, String nextShardIterator) {
        this.currentShardIterators.put(shard.shardId(), nextShardIterator);
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int processedExchanges = 0;
        while (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
            ++processedExchanges;
        }
        return processedExchanges;
    }

    public Kinesis2Endpoint getEndpoint() {
        return (Kinesis2Endpoint)super.getEndpoint();
    }

    private String getShardIterator(Shard shard, KinesisConnection kinesisConnection) throws ExecutionException, InterruptedException {
        String shardId = shard.shardId();
        if (this.currentShardIterators.get(shardId) == null) {
            GetShardIteratorResponse result;
            if (this.currentShardIterators.containsKey(shardId)) {
                this.handleClosedShard(shardId);
            }
            GetShardIteratorRequest.Builder request = GetShardIteratorRequest.builder().streamName(this.getEndpoint().getConfiguration().getStreamName()).shardId(shardId).shardIteratorType(this.getEndpoint().getConfiguration().getIteratorType());
            if (this.hasSequenceNumber()) {
                request.startingSequenceNumber(this.getEndpoint().getConfiguration().getSequenceNumber());
            }
            this.resume(request);
            if (this.getEndpoint().getConfiguration().isAsyncClient()) {
                try {
                    result = (GetShardIteratorResponse)kinesisConnection.getAsyncClient(this.getEndpoint()).getShardIterator((GetShardIteratorRequest)request.build()).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                result = kinesisConnection.getClient(this.getEndpoint()).getShardIterator((GetShardIteratorRequest)request.build());
            }
            this.currentShardIterators.put(shardId, result.shardIterator());
            LOG.debug("Obtained new ShardIterator {} for shard {} on stream {}", new Object[]{result.shardIterator(), shardId, this.getEndpoint().getConfiguration().getStreamName()});
        }
        return this.currentShardIterators.get(shardId);
    }

    private void handleClosedShard(String shardId) {
        switch (this.getEndpoint().getConfiguration().getShardClosed()) {
            case ignore: {
                LOG.warn("The shard with id={} on stream {} reached CLOSE status", (Object)shardId, (Object)this.getEndpoint().getConfiguration().getStreamName());
                break;
            }
            case silent: {
                break;
            }
            case fail: {
                LOG.info("The shard with id={} on stream {} reached CLOSE status", (Object)shardId, (Object)this.getEndpoint().getConfiguration().getStreamName());
                throw new IllegalStateException(new ReachedClosedStatusException(this.getEndpoint().getConfiguration().getStreamName(), shardId));
            }
            default: {
                throw new IllegalArgumentException("Unsupported shard closed strategy");
            }
        }
    }

    private void resume(GetShardIteratorRequest.Builder req) {
        if (this.resumeStrategy == null) {
            return;
        }
        KinesisResumeAdapter adapter = (KinesisResumeAdapter)this.resumeStrategy.getAdapter(KinesisResumeAdapter.class);
        if (adapter == null) {
            LOG.warn("There is a resume strategy setup, but no adapter configured or the type is incorrect");
            return;
        }
        adapter.setRequestBuilder(req);
        adapter.setStreamName(this.getEndpoint().getConfiguration().getStreamName());
        adapter.resume();
    }

    private Queue<Exchange> createExchanges(List<Record> records) {
        ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
        for (Record dataRecord : records) {
            exchanges.add(this.createExchange(dataRecord));
        }
        return exchanges;
    }

    protected Exchange createExchange(Record dataRecord) {
        LOG.debug("Received Kinesis record with partition_key={}", (Object)dataRecord.partitionKey());
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setBody((Object)dataRecord.data().asInputStream());
        exchange.getIn().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)dataRecord.approximateArrivalTimestamp());
        exchange.getIn().setHeader("CamelAwsKinesisPartitionKey", (Object)dataRecord.partitionKey());
        exchange.getIn().setHeader("CamelAwsKinesisSequenceNumber", (Object)dataRecord.sequenceNumber());
        if (dataRecord.approximateArrivalTimestamp() != null) {
            long ts = dataRecord.approximateArrivalTimestamp().getEpochSecond() * 1000L;
            exchange.getIn().setHeader("CamelMessageTimestamp", (Object)ts);
        }
        return exchange;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    private boolean hasSequenceNumber() {
        return !this.getEndpoint().getConfiguration().getSequenceNumber().isEmpty() && (this.getEndpoint().getConfiguration().getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.getEndpoint().getConfiguration().getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER));
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.connection, (String)"connection", (Object)((Object)this));
        if (this.resumeStrategy != null) {
            this.resumeStrategy.loadCache();
        }
    }

    protected Kinesis2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private List<Shard> getShardList(KinesisConnection kinesisConnection) {
        List shardList;
        ListShardsRequest request = (ListShardsRequest)ListShardsRequest.builder().streamName(this.getEndpoint().getConfiguration().getStreamName()).build();
        if (this.getEndpoint().getConfiguration().isAsyncClient()) {
            try {
                shardList = ((ListShardsResponse)kinesisConnection.getAsyncClient(this.getEndpoint()).listShards(request).get()).shards();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            shardList = kinesisConnection.getClient(this.getEndpoint()).listShards(request).shards();
        }
        return shardList;
    }
}

