/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.client.impl;

import java.net.URI;
import java.util.Objects;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.client.KinesisAsyncInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class KinesisAsyncClientStandardImpl
implements KinesisAsyncInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisAsyncClientStandardImpl.class);
    private Kinesis2Configuration configuration;

    public KinesisAsyncClientStandardImpl(Kinesis2Configuration configuration) {
        LOG.trace("Creating an AWS Async Kinesis manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public KinesisAsyncClient getKinesisAsyncClient() {
        KinesisAsyncClientBuilder clientBuilder = KinesisAsyncClient.builder();
        boolean isClientConfigFound = false;
        NettyNioAsyncHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().scheme(this.configuration.getProxyProtocol().toString()).host(this.configuration.getProxyHost()).port(this.configuration.getProxyPort().intValue()).build();
            httpClientBuilder = NettyNioAsyncHttpClient.builder().proxyConfiguration(proxyConfig);
            isClientConfigFound = true;
        }
        if (Objects.nonNull(this.configuration.getAccessKey()) && Objects.nonNull(this.configuration.getSecretKey())) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (KinesisAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (KinesisAsyncClientBuilder)clientBuilder.httpClientBuilder(null);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (KinesisAsyncClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = NettyNioAsyncHttpClient.builder();
            }
            SdkAsyncHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        return (KinesisAsyncClient)clientBuilder.build();
    }
}

