/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kms;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.kms.KMS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.kms.KMS2Configuration;
import org.apache.camel.component.aws2.kms.KMS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.kms.KmsClient;

@org.apache.camel.spi.annotations.Component(value="aws2-kms")
public class KMS2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private KMS2Configuration configuration;

    public KMS2Component() {
        this(null);
    }

    public KMS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KMS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KMS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new KMS2Configuration();
        KMS2Endpoint endpoint = new KMS2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getKmsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon kms client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KMS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KMS2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(KMS2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(KmsClient.class);
        if (clients.size() == 1) {
            configuration.setKmsClient((KmsClient)clients.stream().findFirst().get());
        }
    }
}

