/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kms;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.kms.KMS2Configuration;
import org.apache.camel.component.aws2.kms.KMS2Constants;
import org.apache.camel.component.aws2.kms.KMS2Producer;
import org.apache.camel.component.aws2.kms.client.KMS2ClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.kms.KmsClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-kms", title="AWS Key Management Service (KMS)", syntax="aws2-kms:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=KMS2Constants.class)
public class KMS2Endpoint
extends ScheduledPollEndpoint {
    private KmsClient kmsClient;
    @UriParam
    private KMS2Configuration configuration;

    public KMS2Endpoint(String uri, Component component, KMS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new KMS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.kmsClient = this.configuration.getKmsClient() != null ? this.configuration.getKmsClient() : KMS2ClientFactory.getKmsClient(this.configuration).getKmsClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getKmsClient()) && this.kmsClient != null) {
            this.kmsClient.close();
        }
        super.doStop();
    }

    public KMS2Configuration getConfiguration() {
        return this.configuration;
    }

    public KmsClient getKmsClient() {
        return this.kmsClient;
    }
}

