/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Constants;
import org.apache.camel.component.aws2.lambda.Lambda2Producer;
import org.apache.camel.component.aws2.lambda.client.Lambda2ClientFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.lambda.LambdaClient;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-lambda", title="AWS Lambda", syntax="aws2-lambda:function", producerOnly=true, category={Category.CLOUD, Category.COMPUTING, Category.SERVERLESS}, headersClass=Lambda2Constants.class)
public class Lambda2Endpoint
extends DefaultEndpoint {
    private LambdaClient awsLambdaClient;
    @UriPath
    @Metadata(required=true)
    private String function;
    @UriParam
    private Lambda2Configuration configuration;

    public Lambda2Endpoint(String uri, Component component, Lambda2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Lambda2Producer((Endpoint)this);
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsLambdaClient = this.configuration.getAwsLambdaClient() != null ? this.configuration.getAwsLambdaClient() : Lambda2ClientFactory.getLambdaClient(this.configuration).getLambdaClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAwsLambdaClient()) && this.awsLambdaClient != null) {
            this.awsLambdaClient.close();
        }
        super.doStop();
    }

    public Lambda2Configuration getConfiguration() {
        return this.configuration;
    }

    public LambdaClient getAwsLambdaClient() {
        return this.awsLambdaClient;
    }
}

