/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.util.Map;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;

public class Lambda2ClientHealthCheck
extends AbstractHealthCheck {
    private final Lambda2Endpoint lambda2Endpoint;

    public Lambda2ClientHealthCheck(Lambda2Endpoint lambda2Endpoint, String clientId) {
        super("camel", "aws2-lambda-client-" + clientId);
        this.lambda2Endpoint = lambda2Endpoint;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Lambda2Configuration configuration = this.lambda2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !LambdaClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try (LambdaClient lambda2Client = this.lambda2Endpoint.getAwsLambdaClient();){
            lambda2Client.listFunctions((ListFunctionsRequest)ListFunctionsRequest.builder().maxItems(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

