/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.lambda.Lambda2ComponentVerifierExtension;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.lambda.LambdaClient;

@org.apache.camel.spi.annotations.Component(value="aws2-lambda")
public class Lambda2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Lambda2Component.class);
    @Metadata
    private Lambda2Configuration configuration = new Lambda2Configuration();

    public Lambda2Component() {
        this(null);
    }

    public Lambda2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Lambda2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Lambda2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Lambda2Configuration();
        Lambda2Endpoint endpoint = new Lambda2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setFunction(remaining);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getAwsLambdaClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("accessKey/secretKey or awsLambdaClient must be specified");
        }
        return endpoint;
    }

    public Lambda2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Lambda2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Lambda2Configuration configuration, Lambda2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAwsLambdaClient())) {
            LOG.debug("Looking for an LambdaClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(LambdaClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one LambdaClient instance in the registry");
                configuration.setAwsLambdaClient((LambdaClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No LambdaClient instance in the registry");
            }
        } else {
            LOG.debug("LambdaClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

