/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Endpoint;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfig;

public class Lambda2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Lambda2Producer.class);

    public Lambda2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case getFunction: {
                this.getFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createFunction: {
                this.createFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteFunction: {
                this.deleteFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case invokeFunction: {
                this.invokeFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listFunctions: {
                this.listFunctions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case updateFunction: {
                this.updateFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createEventSourceMapping: {
                this.createEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteEventSourceMapping: {
                this.deleteEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listEventSourceMapping: {
                this.listEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listTags: {
                this.listTags(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case tagResource: {
                this.tagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case untagResource: {
                this.untagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case publishVersion: {
                this.publishVersion(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listVersions: {
                this.listVersions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createAlias: {
                this.createAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteAlias: {
                this.deleteAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case getAlias: {
                this.getAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listAliases: {
                this.listAliases(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetFunctionRequest) {
                GetFunctionResponse result;
                try {
                    result = lambdaClient.getFunction((GetFunctionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("getFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetFunctionResponse result;
            try {
                result = lambdaClient.getFunction((GetFunctionRequest)GetFunctionRequest.builder().functionName(this.getEndpoint().getFunction()).build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("getFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteFunctionRequest) {
                DeleteFunctionResponse result;
                try {
                    result = lambdaClient.deleteFunction((DeleteFunctionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("deleteFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteFunctionResponse result;
            try {
                result = lambdaClient.deleteFunction((DeleteFunctionRequest)DeleteFunctionRequest.builder().functionName(this.getEndpoint().getFunction()).build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("deleteFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listFunctions(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListFunctionsRequest) {
                ListFunctionsResponse result;
                try {
                    result = lambdaClient.listFunctions((ListFunctionsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("listFunctions command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListFunctionsResponse result;
            try {
                result = lambdaClient.listFunctions();
            }
            catch (AwsServiceException ase) {
                LOG.trace("listFunctions command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void invokeFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof InvokeRequest) {
                InvokeResponse result;
                try {
                    result = lambdaClient.invoke((InvokeRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("invokeFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result.payload().asUtf8String());
            }
        } else {
            InvokeResponse result;
            try {
                InvokeRequest request = (InvokeRequest)InvokeRequest.builder().functionName(this.getEndpoint().getFunction()).payload(SdkBytes.fromString((String)((String)exchange.getIn().getBody(String.class)), (Charset)Charset.defaultCharset())).build();
                result = lambdaClient.invoke(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("invokeFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result.payload().asUtf8String());
        }
    }

    private void createFunction(LambdaClient lambdaClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateFunctionRequest) {
                CreateFunctionResponse result;
                try {
                    result = lambdaClient.createFunction((CreateFunctionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("createFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateFunctionResponse result;
            try {
                Map tags;
                Map environmentVariables;
                CreateFunctionRequest.Builder request = CreateFunctionRequest.builder().functionName(this.getEndpoint().getFunction());
                FunctionCode.Builder functionCode = FunctionCode.builder();
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket"))) {
                    String s3Bucket = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket", String.class);
                    functionCode.s3Bucket(s3Bucket);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                    String s3Key = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Key", String.class);
                    functionCode.s3Key(s3Key);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion"))) {
                    String s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion", String.class);
                    functionCode.s3ObjectVersion(s3ObjectVersion);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaZipFile"))) {
                    String zipFile = (String)exchange.getIn().getHeader("CamelAwsLambdaZipFile", String.class);
                    File fileLocalPath = new File(zipFile);
                    try (FileInputStream inputStream = new FileInputStream(fileLocalPath);){
                        functionCode.zipFile(SdkBytes.fromInputStream((InputStream)inputStream));
                    }
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody())) {
                    functionCode.zipFile(SdkBytes.fromByteBuffer((ByteBuffer)((ByteBuffer)exchange.getIn().getBody(ByteBuffer.class))));
                }
                if (!(ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody()) || ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key")))) {
                    throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
                }
                request.code((FunctionCode)functionCode.build());
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRole"))) {
                    throw new IllegalArgumentException("Role must be specified");
                }
                request.role((String)exchange.getIn().getHeader("CamelAwsLambdaRole", String.class));
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRuntime"))) {
                    throw new IllegalArgumentException("Runtime must be specified");
                }
                request.runtime((String)exchange.getIn().getHeader("CamelAwsLambdaRuntime", String.class));
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaHandler"))) {
                    throw new IllegalArgumentException("Handler must be specified");
                }
                request.handler((String)exchange.getIn().getHeader("CamelAwsLambdaHandler", String.class));
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaDescription"))) {
                    String description = (String)exchange.getIn().getHeader("CamelAwsLambdaDescription", String.class);
                    request.description(description);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTargetArn"))) {
                    String targetArn = (String)exchange.getIn().getHeader("CamelAwsLambdaTargetArn", String.class);
                    request.deadLetterConfig((DeadLetterConfig)DeadLetterConfig.builder().targetArn(targetArn).build());
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaMemorySize"))) {
                    Integer memorySize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaMemorySize", Integer.class);
                    request.memorySize(memorySize);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn"))) {
                    String kmsKeyARN = (String)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn", String.class);
                    request.kmsKeyArn(kmsKeyARN);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                    Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                    request.publish(publish);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTimeout"))) {
                    Integer timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaTimeout", Integer.class);
                    request.timeout(timeout);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig"))) {
                    String tracingConfigMode = (String)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig", String.class);
                    request.tracingConfig((TracingConfig)TracingConfig.builder().mode(tracingConfigMode).build());
                }
                if ((environmentVariables = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaEnvironmentVariables", Map.class)))) != null) {
                    request.environment((Environment)Environment.builder().variables(environmentVariables).build());
                }
                if ((tags = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaTags", Map.class)))) != null) {
                    request.tags(tags);
                }
                List securityGroupIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSecurityGroupIds", List.class)));
                List subnetIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSubnetIds", List.class)));
                if (securityGroupIds != null || subnetIds != null) {
                    VpcConfig.Builder vpcConfig = VpcConfig.builder();
                    if (securityGroupIds != null) {
                        vpcConfig.securityGroupIds((Collection)securityGroupIds);
                    }
                    if (subnetIds != null) {
                        vpcConfig.subnetIds((Collection)subnetIds);
                    }
                    request.vpcConfig((VpcConfig)vpcConfig.build());
                }
                result = lambdaClient.createFunction((CreateFunctionRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("createFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateFunction(LambdaClient lambdaClient, Exchange exchange) throws Exception {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateFunctionCodeRequest) {
                UpdateFunctionCodeResponse result;
                try {
                    result = lambdaClient.updateFunctionCode((UpdateFunctionCodeRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("updateFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateFunctionCodeResponse result;
            try {
                UpdateFunctionCodeRequest.Builder request = UpdateFunctionCodeRequest.builder().functionName(this.getEndpoint().getFunction());
                if (ObjectHelper.isEmpty((Object)exchange.getIn().getBody()) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                    throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                    Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                    request.publish(publish);
                }
                result = lambdaClient.updateFunctionCode((UpdateFunctionCodeRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("updateFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateEventSourceMappingRequest) {
                CreateEventSourceMappingResponse result;
                try {
                    result = lambdaClient.createEventSourceMapping((CreateEventSourceMappingRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("createEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateEventSourceMappingResponse result;
            try {
                CreateEventSourceMappingRequest.Builder request = CreateEventSourceMappingRequest.builder().functionName(this.getEndpoint().getFunction());
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn"))) {
                    throw new IllegalArgumentException("Event Source Arn must be specified");
                }
                request.eventSourceArn((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn", String.class));
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize"))) {
                    Integer batchSize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize", Integer.class);
                    request.batchSize(batchSize);
                }
                result = lambdaClient.createEventSourceMapping((CreateEventSourceMappingRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("createEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteEventSourceMappingRequest) {
                DeleteEventSourceMappingResponse result;
                try {
                    result = lambdaClient.deleteEventSourceMapping((DeleteEventSourceMappingRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("deleteEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteEventSourceMappingResponse result;
            try {
                DeleteEventSourceMappingRequest.Builder request = DeleteEventSourceMappingRequest.builder();
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid"))) {
                    throw new IllegalArgumentException("Event Source Arn must be specified");
                }
                request.uuid((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid", String.class));
                result = lambdaClient.deleteEventSourceMapping((DeleteEventSourceMappingRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("deleteEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListEventSourceMappingsRequest) {
                ListEventSourceMappingsResponse result;
                try {
                    result = lambdaClient.listEventSourceMappings((ListEventSourceMappingsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("listEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListEventSourceMappingsResponse result;
            try {
                ListEventSourceMappingsRequest.Builder request = ListEventSourceMappingsRequest.builder().functionName(this.getEndpoint().getFunction());
                result = lambdaClient.listEventSourceMappings((ListEventSourceMappingsRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("listEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listTags(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListTagsRequest) {
                ListTagsResponse result;
                try {
                    result = lambdaClient.listTags((ListTagsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListTagsResponse result;
            try {
                ListTagsRequest.Builder request = ListTagsRequest.builder();
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                    throw new IllegalArgumentException("The resource ARN must be specified");
                }
                String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
                request.resource(resource);
                result = lambdaClient.listTags((ListTagsRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void tagResource(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof TagResourceRequest) {
                TagResourceResponse result;
                try {
                    result = lambdaClient.tagResource((TagResourceRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            TagResourceResponse result;
            try {
                TagResourceRequest.Builder request = TagResourceRequest.builder();
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                    throw new IllegalArgumentException("The resource ARN must be specified");
                }
                String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
                request.resource(resource);
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTags"))) {
                    throw new IllegalArgumentException("The tags must be specified");
                }
                Map tags = (Map)exchange.getIn().getHeader("CamelAwsLambdaResourceTags", Map.class);
                request.tags(tags);
                result = lambdaClient.tagResource((TagResourceRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void untagResource(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UntagResourceRequest) {
                UntagResourceResponse result;
                try {
                    result = lambdaClient.untagResource((UntagResourceRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("untagResource command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UntagResourceResponse result;
            try {
                UntagResourceRequest.Builder request = UntagResourceRequest.builder();
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                    throw new IllegalArgumentException("The resource ARN must be specified");
                }
                String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
                request.resource(resource);
                if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys"))) {
                    throw new IllegalArgumentException("The tag keys must be specified");
                }
                List tagKeys = (List)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys", List.class);
                request.tagKeys((Collection)tagKeys);
                result = lambdaClient.untagResource((UntagResourceRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("untagResource command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void publishVersion(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PublishVersionRequest) {
                PublishVersionResponse result;
                try {
                    result = lambdaClient.publishVersion((PublishVersionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PublishVersionResponse result;
            try {
                PublishVersionRequest.Builder request = PublishVersionRequest.builder().functionName(this.getEndpoint().getFunction());
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription"))) {
                    String description = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription", String.class);
                    request.description(description);
                }
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId"))) {
                    String revisionId = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId", String.class);
                    request.revisionId(revisionId);
                }
                result = lambdaClient.publishVersion((PublishVersionRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listVersions(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListVersionsByFunctionRequest) {
                ListVersionsByFunctionResponse result;
                try {
                    result = lambdaClient.listVersionsByFunction((ListVersionsByFunctionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListVersionsByFunctionResponse result;
            try {
                ListVersionsByFunctionRequest request = (ListVersionsByFunctionRequest)ListVersionsByFunctionRequest.builder().functionName(this.getEndpoint().getFunction()).build();
                result = lambdaClient.listVersionsByFunction(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateAliasRequest) {
                CreateAliasResponse result;
                try {
                    result = lambdaClient.createAlias((CreateAliasRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("createAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateAliasResponse result;
            try {
                CreateAliasRequest.Builder request = CreateAliasRequest.builder().functionName(this.getEndpoint().getFunction());
                String version = (String)exchange.getIn().getHeader("CamelAwsLambdaFunctionVersion", String.class);
                String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
                if (ObjectHelper.isEmpty((Object)version) || ObjectHelper.isEmpty((Object)aliasName)) {
                    throw new IllegalArgumentException("Function Version and alias must be specified to create an alias");
                }
                request.functionVersion(version);
                request.name(aliasName);
                if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionDescription"))) {
                    String aliasDescription = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionDescription", String.class);
                    request.description(aliasDescription);
                }
                result = lambdaClient.createAlias((CreateAliasRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("createAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteAliasRequest) {
                DeleteAliasResponse result;
                try {
                    result = lambdaClient.deleteAlias((DeleteAliasRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("deleteAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteAliasResponse result;
            try {
                DeleteAliasRequest.Builder request = DeleteAliasRequest.builder().functionName(this.getEndpoint().getFunction());
                String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
                if (ObjectHelper.isEmpty((Object)aliasName)) {
                    throw new IllegalArgumentException("Function alias must be specified to delete an alias");
                }
                request.name(aliasName);
                result = lambdaClient.deleteAlias((DeleteAliasRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("deleteAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetAliasRequest) {
                GetAliasResponse result;
                try {
                    result = lambdaClient.getAlias((GetAliasRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("getAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetAliasResponse result;
            try {
                GetAliasRequest.Builder request = GetAliasRequest.builder().functionName(this.getEndpoint().getFunction());
                String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
                if (ObjectHelper.isEmpty((Object)aliasName)) {
                    throw new IllegalArgumentException("Function alias must be specified to get an alias");
                }
                request.name(aliasName);
                result = lambdaClient.getAlias((GetAliasRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("getAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listAliases(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListAliasesRequest) {
                ListAliasesResponse result;
                try {
                    result = lambdaClient.listAliases((ListAliasesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("listAliases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Lambda2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListAliasesResponse result;
            try {
                ListAliasesRequest.Builder request = ListAliasesRequest.builder().functionName(this.getEndpoint().getFunction());
                String version = (String)exchange.getIn().getHeader("CamelAwsLambdaFunctionVersion", String.class);
                if (ObjectHelper.isEmpty((Object)version)) {
                    throw new IllegalArgumentException("Function Version must be specified to list aliases for a function");
                }
                request.functionVersion(version);
                result = lambdaClient.listAliases((ListAliasesRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("listAliases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Lambda2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private Lambda2Operations determineOperation(Exchange exchange) {
        Lambda2Operations operation = (Lambda2Operations)((Object)exchange.getIn().getHeader("CamelAwsLambdaOperation", Lambda2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation() == null ? Lambda2Operations.invokeFunction : this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Lambda2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Lambda2Endpoint getEndpoint() {
        return (Lambda2Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

