/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.mq.MQ2ComponentVerifierExtension;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.mq.MqClient;

@org.apache.camel.spi.annotations.Component(value="aws2-mq")
public class MQ2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MQ2Component.class);
    @Metadata
    private MQ2Configuration configuration = new MQ2Configuration();

    public MQ2Component() {
        this(null);
    }

    public MQ2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MQ2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MQ2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MQ2Configuration();
        MQ2Endpoint endpoint = new MQ2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getAmazonMqClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonMQClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MQ2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MQ2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(MQ2Configuration configuration, MQ2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonMqClient())) {
            LOG.debug("Looking for an MqClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(MqClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one MqClient instance in the registry");
                configuration.setAmazonMqClient((MqClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No MqClient instance in the registry");
            }
        } else {
            LOG.debug("MqClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

