/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.msk.MSK2ComponentVerifierExtension;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-msk")
public class MSK2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MSK2Component.class);
    @Metadata
    private MSK2Configuration configuration = new MSK2Configuration();

    public MSK2Component() {
        this(null);
    }

    public MSK2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MSK2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSK2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MSK2Configuration();
        MSK2Endpoint endpoint = new MSK2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon msk client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MSK2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSK2Configuration configuration) {
        this.configuration = configuration;
    }
}

