/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Consumer;
import org.apache.camel.component.aws2.s3.AWS2S3Producer;
import org.apache.camel.component.aws2.s3.client.AWS2S3ClientFactory;
import org.apache.camel.component.aws2.s3.stream.AWS2S3StreamUploadProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-s3", title="AWS 2 S3 Storage Service", syntax="aws2-s3://bucketNameOrArn", category={Category.CLOUD, Category.FILE})
public class AWS2S3Endpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Endpoint.class);
    private S3Client s3Client;
    @UriPath(description="Bucket name or ARN")
    @Metadata(required=true)
    private String bucketNameOrArn;
    @UriParam
    private AWS2S3Configuration configuration;
    @UriParam(label="consumer", defaultValue="10")
    private int maxMessagesPerPoll = 10;
    @UriParam(label="consumer", defaultValue="60")
    private int maxConnections = 50 + this.maxMessagesPerPoll;

    public AWS2S3Endpoint(String uri, Component comp, AWS2S3Configuration configuration) {
        super(uri, comp);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AWS2S3Consumer s3Consumer = new AWS2S3Consumer(this, processor);
        this.configureConsumer((Consumer)s3Consumer);
        s3Consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return s3Consumer;
    }

    public Producer createProducer() throws Exception {
        if (!this.configuration.isStreamingUploadMode()) {
            return new AWS2S3Producer((Endpoint)this);
        }
        return new AWS2S3StreamUploadProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.s3Client = this.configuration.getAmazonS3Client() != null ? this.configuration.getAmazonS3Client() : AWS2S3ClientFactory.getAWSS3Client(this.configuration).getS3Client();
        String fileName = this.getConfiguration().getFileName();
        if (fileName != null) {
            LOG.trace("File name [{}] requested, so skipping bucket check...", (Object)fileName);
            return;
        }
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Querying whether bucket [{}] already exists...", (Object)bucketName);
        String prefix = this.getConfiguration().getPrefix();
        try {
            this.s3Client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            LOG.trace("Bucket [{}] already exists", (Object)bucketName);
            return;
        }
        catch (AwsServiceException ase) {
            if (ase.awsErrorDetails().sdkHttpResponse().statusCode() != 404) {
                throw ase;
            }
            LOG.trace("Bucket [{}] doesn't exist yet", (Object)bucketName);
            if (this.getConfiguration().isAutoCreateBucket()) {
                CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.getConfiguration().getBucketName()).build();
                LOG.trace("Creating bucket [{}] in region [{}] with request [{}]...", new Object[]{this.configuration.getBucketName(), this.configuration.getRegion(), createBucketRequest});
                this.s3Client.createBucket(createBucketRequest);
                LOG.trace("Bucket created");
            }
            if (this.configuration.getPolicy() != null) {
                LOG.trace("Updating bucket [{}] with policy [{}]", (Object)bucketName, (Object)this.configuration.getPolicy());
                this.s3Client.putBucketPolicy((PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(bucketName).policy(this.configuration.getPolicy()).build());
                LOG.trace("Bucket policy updated");
            }
            return;
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonS3Client()) && this.s3Client != null) {
            this.s3Client.close();
        }
        super.doStop();
    }

    public AWS2S3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWS2S3Configuration configuration) {
        this.configuration = configuration;
    }

    public void setS3Client(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public S3Client getS3Client() {
        return this.s3Client;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }
}

