/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class AWS2S3EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = "://bucketNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "aws2-s3".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "bucketNameOrArn", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(68);
        props.add("customerAlgorithm");
        props.add("fileName");
        props.add("batchMessageNumber");
        props.add("useCustomerKey");
        props.add("bucketNameOrArn");
        props.add("customerKeyId");
        props.add("prefix");
        props.add("useAwsKMS");
        props.add("initialDelay");
        props.add("pojoRequest");
        props.add("customerKeyMD5");
        props.add("proxyPort");
        props.add("bridgeErrorHandler");
        props.add("awsKMSKeyId");
        props.add("delimiter");
        props.add("streamingUploadMode");
        props.add("amazonS3Client");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("moveAfterRead");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("streamingUploadTimeout");
        props.add("proxyHost");
        props.add("backoffIdleThreshold");
        props.add("trustAllCertificates");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("includeBody");
        props.add("startScheduler");
        props.add("accessKey");
        props.add("deleteAfterWrite");
        props.add("region");
        props.add("exceptionHandler");
        props.add("restartingPolicy");
        props.add("backoffMultiplier");
        props.add("destinationBucket");
        props.add("amazonS3Presigner");
        props.add("partSize");
        props.add("scheduler");
        props.add("multiPartUpload");
        props.add("storageClass");
        props.add("useFixedDelay");
        props.add("doneFileName");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("policy");
        props.add("maxConnections");
        props.add("timeUnit");
        props.add("autoCreateBucket");
        props.add("destinationBucketSuffix");
        props.add("proxyProtocol");
        props.add("secretKey");
        props.add("uriEndpointOverride");
        props.add("exchangePattern");
        props.add("keyName");
        props.add("includeFolders");
        props.add("useDefaultCredentialsProvider");
        props.add("destinationBucketPrefix");
        props.add("autocloseBody");
        props.add("pollStrategy");
        props.add("overrideEndpoint");
        props.add("deleteAfterRead");
        props.add("batchSize");
        props.add("operation");
        props.add("namingStrategy");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

