/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.util.ObjectHelper;

public final class AWS2S3Utils {
    private AWS2S3Utils() {
    }

    public static String determineBucketName(Exchange exchange, AWS2S3Configuration configuration) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((Object)bucketName)) {
            bucketName = configuration.getBucketName();
        }
        if (bucketName == null) {
            throw new IllegalArgumentException("AWS S3 Bucket name header is missing or not configured.");
        }
        return bucketName;
    }

    public static String determineStorageClass(Exchange exchange, AWS2S3Configuration configuration) {
        String storageClass = (String)exchange.getIn().getHeader("CamelAwsS3StorageClass", String.class);
        if (storageClass == null) {
            storageClass = configuration.getStorageClass();
        }
        return storageClass;
    }

    public static String determineFileExtension(String keyName) {
        int extPosition = keyName.lastIndexOf(".");
        if (extPosition == -1) {
            return "";
        }
        return keyName.substring(extPosition);
    }

    public static String determineFileName(String keyName) {
        int extPosition = keyName.lastIndexOf(".");
        if (extPosition == -1) {
            return keyName;
        }
        return keyName.substring(0, extPosition);
    }

    public static ByteArrayOutputStream determineLengthInputStream(InputStream is) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((count = is.read(bytes)) > 0) {
            out.write(bytes, 0, count);
        }
        return out;
    }

    public static String determineKey(Exchange exchange, AWS2S3Configuration configuration) {
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (ObjectHelper.isEmpty((Object)key)) {
            key = configuration.getKeyName();
        }
        if (key == null) {
            throw new IllegalArgumentException("AWS S3 Key header missing.");
        }
        return key;
    }
}

