/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.utils.AWS2S3Utils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

public class AWS2S3Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Producer.class);

    public AWS2S3Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        AWS2S3Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            if (this.getConfiguration().isMultiPartUpload()) {
                this.processMultiPart(exchange);
            } else {
                this.processSingleOp(exchange);
            }
        } else {
            switch (operation) {
                case copyObject: {
                    this.copyObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteObject: {
                    this.deleteObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case listBuckets: {
                    this.listBuckets(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteBucket: {
                    this.deleteBucket(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case listObjects: {
                    this.listObjects(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObject: {
                    this.getObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObjectRange: {
                    this.getObjectRange(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case createDownloadLink: {
                    this.createDownloadLink(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processMultiPart(Exchange exchange) throws Exception {
        String contentType;
        BucketCannedACL acl;
        String cannedAcl;
        File filePayload = null;
        Object obj = exchange.getIn().getMandatoryBody();
        if (obj instanceof WrappedFile) {
            obj = ((WrappedFile)obj).getFile();
        }
        if (!(obj instanceof File)) {
            throw new IllegalArgumentException("aws2-s3: MultiPart upload requires a File input.");
        }
        filePayload = (File)obj;
        Map<String, String> objectMetadata = this.determineMetadata(exchange);
        if (objectMetadata.containsKey("Content-Length")) {
            if (objectMetadata.get("Content-Length").equalsIgnoreCase("0")) {
                objectMetadata.put("Content-Length", String.valueOf(filePayload.length()));
            }
        } else {
            objectMetadata.put("Content-Length", String.valueOf(filePayload.length()));
        }
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName);
        String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
        if (storageClass != null) {
            createMultipartUploadRequest.storageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
            createMultipartUploadRequest.acl(objectAcl);
        }
        if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
            createMultipartUploadRequest.acl(acl.toString());
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            createMultipartUploadRequest.contentType(contentType);
        }
        if (this.getConfiguration().isUseAwsKMS()) {
            createMultipartUploadRequest.ssekmsKeyId(this.getConfiguration().getAwsKMSKeyId());
            createMultipartUploadRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        }
        if (this.getConfiguration().isUseCustomerKey()) {
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyId())) {
                createMultipartUploadRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
            }
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyMD5())) {
                createMultipartUploadRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
            }
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerAlgorithm())) {
                createMultipartUploadRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
            }
        }
        LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)createMultipartUploadRequest, (Object)exchange);
        CreateMultipartUploadResponse initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
        long contentLength = Long.parseLong(objectMetadata.get("Content-Length"));
        ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        long partSize = this.getConfiguration().getPartSize();
        CompleteMultipartUploadResponse uploadResult = null;
        long filePosition = 0L;
        try {
            int part = 1;
            while (filePosition < contentLength) {
                partSize = Math.min(partSize, contentLength - filePosition);
                UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId()).partNumber(Integer.valueOf(part)).build();
                LOG.trace("Uploading part [{}] for {}", (Object)part, (Object)keyName);
                try (FileInputStream fileInputStream = new FileInputStream(filePayload);){
                    long skipped;
                    if (filePosition > 0L && (skipped = ((InputStream)fileInputStream).skip(filePosition)) == 0L) {
                        LOG.warn("While trying to upload the file {} file, 0 bytes were skipped", (Object)keyName);
                    }
                    String etag = this.getEndpoint().getS3Client().uploadPart(uploadRequest, RequestBody.fromInputStream((InputStream)fileInputStream, (long)partSize)).eTag();
                    CompletedPart partUpload = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(part)).eTag(etag).build();
                    completedParts.add(partUpload);
                    filePosition += partSize;
                }
                ++part;
            }
            CompletedMultipartUpload completeMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
            CompleteMultipartUploadRequest compRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().multipartUpload(completeMultipartUpload).bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId()).build();
            uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload(compRequest);
        }
        catch (Exception e) {
            this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId()).build());
            throw e;
        }
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
        if (uploadResult.versionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
        }
        if (this.getConfiguration().isDeleteAfterWrite()) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSingleOp(Exchange exchange) throws Exception {
        PutObjectRequest.Builder putObjectRequest = PutObjectRequest.builder();
        Map<String, String> objectMetadata = this.determineMetadata(exchange);
        long contentLength = Long.parseLong(objectMetadata.getOrDefault("Content-Length", "-1"));
        Object obj = exchange.getIn().getMandatoryBody();
        InputStream inputStream = null;
        File filePayload = null;
        try {
            if (obj instanceof WrappedFile) {
                obj = ((WrappedFile)obj).getFile();
            }
            if (obj instanceof File) {
                filePayload = (File)obj;
                contentLength = filePayload.length();
            } else {
                inputStream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                if (contentLength <= 0L && (contentLength = AWS2S3Utils.determineLengthInputStream(inputStream)) == -1L) {
                    LOG.debug("The content length is not defined. It needs to be determined by reading the data into memory");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOHelper.copyAndCloseInput((InputStream)inputStream, (OutputStream)baos);
                    byte[] arr = baos.toByteArray();
                    contentLength = arr.length;
                    inputStream = new ByteArrayInputStream(arr);
                }
            }
            if (contentLength > 0L) {
                objectMetadata.put("Content-Length", String.valueOf(contentLength));
            }
            this.doPutObject(exchange, putObjectRequest, objectMetadata, filePayload, inputStream, contentLength);
        }
        catch (Throwable throwable) {
            IOHelper.close(inputStream);
            throw throwable;
        }
        IOHelper.close((Closeable)inputStream);
        if (this.getConfiguration().isDeleteAfterWrite() && filePayload != null) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    private void doPutObject(Exchange exchange, PutObjectRequest.Builder putObjectRequest, Map<String, String> objectMetadata, File file, InputStream inputStream, long contentLength) {
        String contentMd5;
        BucketCannedACL acl;
        String contentType;
        String cannedAcl;
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String key = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        putObjectRequest.bucket(bucketName).key(key).metadata(objectMetadata);
        String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
        if (storageClass != null) {
            putObjectRequest.storageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
            putObjectRequest.acl(objectAcl);
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            putObjectRequest.contentType(contentType);
        }
        if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
            putObjectRequest.acl(acl.toString());
        }
        if ((contentMd5 = (String)exchange.getIn().getHeader("CamelAwsS3ContentMD5", String.class)) != null) {
            putObjectRequest.contentMD5(contentMd5);
        }
        if (this.getConfiguration().isUseAwsKMS() && ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAwsKMSKeyId())) {
            putObjectRequest.ssekmsKeyId(this.getConfiguration().getAwsKMSKeyId());
            putObjectRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        }
        if (this.getConfiguration().isUseCustomerKey()) {
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyId())) {
                putObjectRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
            }
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyMD5())) {
                putObjectRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
            }
            if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerAlgorithm())) {
                putObjectRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
            }
        }
        LOG.trace("Put object [{}] from exchange [{}]...", (Object)putObjectRequest, (Object)exchange);
        RequestBody rb = file != null ? RequestBody.fromFile((File)file) : RequestBody.fromInputStream((InputStream)inputStream, (long)contentLength);
        PutObjectResponse putObjectResult = this.getEndpoint().getS3Client().putObject((PutObjectRequest)putObjectRequest.build(), rb);
        LOG.trace("Received result [{}]", (Object)putObjectResult);
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)putObjectResult.eTag());
        if (putObjectResult.versionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)putObjectResult.versionId());
        }
    }

    private void copyObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String sourceKey = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        String destinationKey = (String)exchange.getIn().getHeader("CamelAwsS3DestinationKey", String.class);
        String bucketNameDestination = (String)exchange.getIn().getHeader("CamelAwsS3BucketDestinationName", String.class);
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CopyObjectRequest) {
                CopyObjectResponse result = s3Client.copyObject((CopyObjectRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            if (ObjectHelper.isEmpty((Object)bucketNameDestination)) {
                throw new IllegalArgumentException("Bucket Name Destination must be specified for copyObject Operation");
            }
            if (ObjectHelper.isEmpty((Object)destinationKey)) {
                throw new IllegalArgumentException("Destination Key must be specified for copyObject Operation");
            }
            CopyObjectRequest.Builder copyObjectRequest = CopyObjectRequest.builder();
            copyObjectRequest = CopyObjectRequest.builder().destinationBucket(bucketNameDestination).destinationKey(destinationKey).copySource(bucketName + "/" + sourceKey);
            if (this.getConfiguration().isUseAwsKMS() && ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAwsKMSKeyId())) {
                copyObjectRequest.ssekmsKeyId(this.getConfiguration().getAwsKMSKeyId());
                copyObjectRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
            }
            if (this.getConfiguration().isUseCustomerKey()) {
                if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyId())) {
                    copyObjectRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
                }
                if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyMD5())) {
                    copyObjectRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
                }
                if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerAlgorithm())) {
                    copyObjectRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
                }
            }
            CopyObjectResponse copyObjectResult = s3Client.copyObject((CopyObjectRequest)copyObjectRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            if (copyObjectResult.versionId() != null) {
                message.setHeader("CamelAwsS3VersionId", (Object)copyObjectResult.versionId());
            }
        }
    }

    private void deleteObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String sourceKey = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteObjectRequest) {
                s3Client.deleteObject((DeleteObjectRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)true);
            }
        } else {
            DeleteObjectRequest.Builder deleteObjectRequest = DeleteObjectRequest.builder().bucket(bucketName).key(sourceKey);
            s3Client.deleteObject((DeleteObjectRequest)deleteObjectRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)true);
        }
    }

    private void listBuckets(S3Client s3Client, Exchange exchange) {
        ListBucketsResponse bucketsList = s3Client.listBuckets();
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)bucketsList.buckets());
    }

    private void deleteBucket(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteBucketRequest) {
                DeleteBucketResponse resp = s3Client.deleteBucket((DeleteBucketRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)resp);
            }
        } else {
            DeleteBucketRequest.Builder deleteBucketRequest = DeleteBucketRequest.builder().bucket(bucketName);
            DeleteBucketResponse resp = s3Client.deleteBucket((DeleteBucketRequest)deleteBucketRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)resp);
        }
    }

    private void getObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectRequest) {
                ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)payload, ResponseTransformer.toInputStream());
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)res);
            }
        } else {
            String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
            String sourceKey = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
            GetObjectRequest.Builder req = GetObjectRequest.builder().bucket(bucketName).key(sourceKey);
            ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)req.build(), ResponseTransformer.toInputStream());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)res);
        }
    }

    private void getObjectRange(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String sourceKey = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        String rangeStart = (String)exchange.getIn().getHeader("CamelAwsS3RangeStart", String.class);
        String rangeEnd = (String)exchange.getIn().getHeader("CamelAwsS3RangeEnd", String.class);
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectRequest) {
                ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)payload, ResponseTransformer.toInputStream());
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)res);
            }
        } else {
            if (ObjectHelper.isEmpty((Object)rangeStart) || ObjectHelper.isEmpty((Object)rangeEnd)) {
                throw new IllegalArgumentException("A Range start and range end header must be configured to perform a range get operation.");
            }
            GetObjectRequest.Builder req = GetObjectRequest.builder().bucket(bucketName).key(sourceKey).range("bytes=" + Long.parseLong(rangeStart) + "-" + Long.parseLong(rangeEnd));
            ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)req.build(), ResponseTransformer.toInputStream());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)res);
        }
    }

    private void listObjects(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListObjectsRequest) {
                ListObjectsResponse objectList = s3Client.listObjects((ListObjectsRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)objectList.contents());
            }
        } else {
            ListObjectsResponse objectList = s3Client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)objectList.contents());
        }
    }

    private void createDownloadLink(S3Client s3Client, Exchange exchange) {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String key = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        long milliSeconds = 0L;
        Long expirationMillis = (Long)exchange.getIn().getHeader("CamelAwsS3DowloadLinkExpirationTime", Long.class);
        milliSeconds = expirationMillis != null ? (milliSeconds += expirationMillis.longValue()) : (milliSeconds += 3600000L);
        S3Presigner presigner = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAmazonS3Presigner()) ? this.getConfiguration().getAmazonS3Presigner() : S3Presigner.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getConfiguration().getAccessKey(), (String)this.getConfiguration().getSecretKey()))).region(Region.of((String)this.getConfiguration().getRegion())).build();
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
        GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMillis(milliSeconds)).getObjectRequest(getObjectRequest).build();
        PresignedGetObjectRequest presignedGetObjectRequest = presigner.presignGetObject(getObjectPresignRequest);
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)presignedGetObjectRequest.url().toString());
        if (ObjectHelper.isEmpty((Object)this.getConfiguration().getAmazonS3Presigner())) {
            presigner.close();
        }
    }

    private AWS2S3Operations determineOperation(Exchange exchange) {
        AWS2S3Operations operation = (AWS2S3Operations)((Object)exchange.getIn().getHeader("CamelAwsS3Operation", AWS2S3Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    private Map<String, String> determineMetadata(Exchange exchange) {
        String contentMD5;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        HashMap<String, String> objectMetadata = new HashMap<String, String>();
        Long contentLength = (Long)exchange.getIn().getHeader("CamelAwsS3ContentLength", Long.class);
        if (contentLength != null) {
            objectMetadata.put("Content-Length", String.valueOf(contentLength));
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            objectMetadata.put("Content-Type", contentType);
        }
        if ((cacheControl = (String)exchange.getIn().getHeader("CamelAwsS3ContentControl", String.class)) != null) {
            objectMetadata.put("Cache-Control", cacheControl);
        }
        if ((contentDisposition = (String)exchange.getIn().getHeader("CamelAwsS3ContentDisposition", String.class)) != null) {
            objectMetadata.put("Content-Disposition", contentDisposition);
        }
        if ((contentEncoding = (String)exchange.getIn().getHeader("CamelAwsS3ContentEncoding", String.class)) != null) {
            objectMetadata.put("Content-Encoding", contentEncoding);
        }
        if ((contentMD5 = (String)exchange.getIn().getHeader("CamelAwsS3ContentMD5", String.class)) != null) {
            objectMetadata.put("Content-Md5", contentMD5);
        }
        return objectMetadata;
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

