/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import org.apache.camel.spi.Metadata;

public interface AWS2S3Constants {
    @Metadata(description="The bucket Name which this object will be stored or which will be used for the current operation or in which this object is contained.", javaType="String")
    public static final String BUCKET_NAME = "CamelAwsS3BucketName";
    @Metadata(label="producer", description="The bucket Destination Name which will be used for the current operation", javaType="String")
    public static final String BUCKET_DESTINATION_NAME = "CamelAwsS3BucketDestinationName";
    @Metadata(description="The *optional* Cache-Control HTTP header which allows the user to\nspecify caching behavior along the HTTP request/reply chain.", javaType="String")
    public static final String CACHE_CONTROL = "CamelAwsS3ContentControl";
    @Metadata(description="The *optional* Content-Disposition HTTP header, which specifies\npresentational information such as the recommended filename for the\nobject to be saved as.", javaType="String")
    public static final String CONTENT_DISPOSITION = "CamelAwsS3ContentDisposition";
    @Metadata(description="The *optional* Content-Encoding HTTP header specifying what content\nencodings have been applied to the object and what decoding mechanisms\nmust be applied in order to obtain the media-type referenced by the\nContent-Type field.", javaType="String")
    public static final String CONTENT_ENCODING = "CamelAwsS3ContentEncoding";
    @Metadata(description="The Content-Length HTTP header indicating the size of the associated\nobject in bytes.", javaType="Long")
    public static final String CONTENT_LENGTH = "CamelAwsS3ContentLength";
    @Metadata(description="The base64 encoded 128-bit MD5 digest of the associated object (content\n- not including headers) according to RFC 1864. This data is used as a\nmessage integrity check to verify that the data received by Amazon S3 is\nthe same data that the caller sent.", javaType="String")
    public static final String CONTENT_MD5 = "CamelAwsS3ContentMD5";
    @Metadata(description="The Content-Type HTTP header, which indicates the type of content stored\nin the associated object. The value of this header is a standard MIME\ntype.", javaType="String")
    public static final String CONTENT_TYPE = "CamelAwsS3ContentType";
    @Metadata(description="(producer) The ETag value for the newly uploaded object.\n(consumer) The hex encoded 128-bit MD5 digest of the associated object according to\nRFC 1864. This data is used as an integrity check to verify that the\ndata received by the caller is the same data that was sent by Amazon S3.", javaType="String")
    public static final String E_TAG = "CamelAwsS3ETag";
    @Metadata(description="The key under which this object is stored or will be stored or which will be used for the current operation", javaType="String")
    public static final String KEY = "CamelAwsS3Key";
    @Metadata(label="producer", description="The Destination key which will be used for the current operation", javaType="String")
    public static final String DESTINATION_KEY = "CamelAwsS3DestinationKey";
    @Metadata(description="The value of the Last-Modified header, indicating the date and time at\nwhich Amazon S3 last recorded a modification to the associated object.", javaType="Date")
    public static final String LAST_MODIFIED = "CamelAwsS3LastModified";
    @Metadata(description="The storage class of this object.", javaType="String")
    public static final String STORAGE_CLASS = "CamelAwsS3StorageClass";
    @Metadata(description="(producer) The *optional* version ID of the newly uploaded object.\n(consumer) The version ID of the associated Amazon S3 object if available. Version\nIDs are only assigned to objects when an object is uploaded to an Amazon\nS3 bucket that has object versioning enabled.", javaType="String")
    public static final String VERSION_ID = "CamelAwsS3VersionId";
    @Metadata(label="producer", description="The canned acl that will be applied to the object. see\n`software.amazon.awssdk.services.s3.model.ObjectCannedACL` for allowed\nvalues.", javaType="String")
    public static final String CANNED_ACL = "CamelAwsS3CannedAcl";
    @Metadata(label="producer", description="A well constructed Amazon S3 Access Control List object.", javaType="software.amazon.awssdk.services.s3.model.BucketCannedACL")
    public static final String ACL = "CamelAwsS3Acl";
    @Metadata(description="The operation to perform. Permitted values are copyObject, deleteObject, listBuckets, deleteBucket, listObjects", javaType="String")
    public static final String S3_OPERATION = "CamelAwsS3Operation";
    @Metadata(description="Sets the server-side encryption algorithm when encrypting\nthe object using AWS-managed keys. For example use AES256.", javaType="String")
    public static final String SERVER_SIDE_ENCRYPTION = "CamelAwsS3ServerSideEncryption";
    @Metadata(label="consumer", description="If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header.", javaType="String")
    public static final String EXPIRATION_TIME = "CamelAwsS3ExpirationTime";
    @Metadata(label="consumer", description="Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.", javaType="software.amazon.awssdk.services.s3.model.ReplicationStatus")
    public static final String REPLICATION_STATUS = "CamelAwsS3ReplicationStatus";
    @Metadata(label="producer", description="The position of the first byte to get", javaType="String")
    public static final String RANGE_START = "CamelAwsS3RangeStart";
    @Metadata(label="producer", description="The position of the last byte to get", javaType="String")
    public static final String RANGE_END = "CamelAwsS3RangeEnd";
    @Metadata(label="producer", description="The expiration time of the download link in milliseconds", javaType="Long")
    public static final String DOWNLOAD_LINK_EXPIRATION_TIME = "CamelAwsS3DowloadLinkExpirationTime";
    @Metadata(description="A map of metadata to be stored or stored with the object in S3. More details about\nmetadata https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html[here].", javaType="Map<String, String>")
    public static final String METADATA = "CamelAwsS3Metadata";
    @Metadata(label="consumer", description="The timestamp of the message", javaType="long")
    public static final String MESSAGE_TIMESTAMP = "CamelMessageTimestamp";
}

