/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.s3.AWS2S3ComponentVerifierExtension;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;

@org.apache.camel.spi.annotations.Component(value="aws2-s3")
public class AWS2S3Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Component.class);
    @Metadata
    private AWS2S3Configuration configuration = new AWS2S3Configuration();

    public AWS2S3Component() {
        this(null);
    }

    public AWS2S3Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new AWS2S3ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        if (remaining.startsWith("arn:")) {
            remaining = remaining.substring(remaining.lastIndexOf(":") + 1, remaining.length());
        }
        AWS2S3Configuration configuration = this.configuration != null ? this.configuration.copy() : new AWS2S3Configuration();
        configuration.setBucketName(remaining);
        AWS2S3Endpoint endpoint = new AWS2S3Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (!(configuration.isUseIAMCredentials().booleanValue() || configuration.getAmazonS3Client() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useIAMCredentials is set to false, AmazonS3Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public AWS2S3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWS2S3Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(AWS2S3Configuration configuration, AWS2S3Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonS3Client())) {
            LOG.debug("Looking for an S3Client instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(S3Client.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one S3Client instance in the registry");
                configuration.setAmazonS3Client((S3Client)clients.stream().findFirst().get());
            } else {
                LOG.debug("No S3Client instance in the registry");
            }
        } else {
            LOG.debug("S3Client instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

