/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.s3.AWS2S3Component;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;

public class AWS2S3ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AWS2S3Configuration getOrCreateConfiguration(AWS2S3Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AWS2S3Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AWS2S3Component target = (AWS2S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                this.getOrCreateConfiguration(target).setAmazonS3Client((S3Client)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, S3Client.class, (Object)value));
                return true;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                this.getOrCreateConfiguration(target).setAutocloseBody((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                this.getOrCreateConfiguration(target).setAwsKMSKeyId((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((AWS2S3Configuration)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWS2S3Configuration.class, (Object)value));
                return true;
            }
            case "customeralgorithm": 
            case "customerAlgorithm": {
                this.getOrCreateConfiguration(target).setCustomerAlgorithm((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customerkeyid": 
            case "customerKeyId": {
                this.getOrCreateConfiguration(target).setCustomerKeyId((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customerkeymd5": 
            case "customerKeyMD5": {
                this.getOrCreateConfiguration(target).setCustomerKeyMD5((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                this.getOrCreateConfiguration(target).setDeleteAfterWrite((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                this.getOrCreateConfiguration(target).setDestinationBucket((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filename": 
            case "fileName": {
                this.getOrCreateConfiguration(target).setFileName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includefolders": 
            case "includeFolders": {
                this.getOrCreateConfiguration(target).setIncludeFolders((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyname": 
            case "keyName": {
                this.getOrCreateConfiguration(target).setKeyName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                this.getOrCreateConfiguration(target).setMoveAfterRead((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                this.getOrCreateConfiguration(target).setMultiPartUpload((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((AWS2S3Operations)((Object)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWS2S3Operations.class, (Object)value)));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "partsize": 
            case "partSize": {
                this.getOrCreateConfiguration(target).setPartSize((Long)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useawskms": 
            case "useAwsKMS": {
                this.getOrCreateConfiguration(target).setUseAwsKMS((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usecustomerkey": 
            case "useCustomerKey": {
                this.getOrCreateConfiguration(target).setUseCustomerKey((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                this.getOrCreateConfiguration(target).setUseIAMCredentials((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonS3Client", S3Client.class);
        answer.put("autoCreateBucket", Boolean.TYPE);
        answer.put("autocloseBody", Boolean.TYPE);
        answer.put("awsKMSKeyId", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("configuration", AWS2S3Configuration.class);
        answer.put("customerAlgorithm", String.class);
        answer.put("customerKeyId", String.class);
        answer.put("customerKeyMD5", String.class);
        answer.put("deleteAfterRead", Boolean.TYPE);
        answer.put("deleteAfterWrite", Boolean.TYPE);
        answer.put("delimiter", String.class);
        answer.put("destinationBucket", String.class);
        answer.put("fileName", String.class);
        answer.put("includeBody", Boolean.TYPE);
        answer.put("includeFolders", Boolean.TYPE);
        answer.put("keyName", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("moveAfterRead", Boolean.TYPE);
        answer.put("multiPartUpload", Boolean.TYPE);
        answer.put("operation", AWS2S3Operations.class);
        answer.put("overrideEndpoint", Boolean.TYPE);
        answer.put("partSize", Long.TYPE);
        answer.put("pojoRequest", Boolean.TYPE);
        answer.put("policy", String.class);
        answer.put("prefix", String.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("storageClass", String.class);
        answer.put("uriEndpointOverride", String.class);
        answer.put("useAwsKMS", Boolean.TYPE);
        answer.put("useCustomerKey", Boolean.TYPE);
        answer.put("useIAMCredentials", Boolean.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AWS2S3Component target = (AWS2S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return this.getOrCreateConfiguration(target).getAmazonS3Client();
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return this.getOrCreateConfiguration(target).isAutocloseBody();
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return this.getOrCreateConfiguration(target).getAwsKMSKeyId();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "customeralgorithm": 
            case "customerAlgorithm": {
                return this.getOrCreateConfiguration(target).getCustomerAlgorithm();
            }
            case "customerkeyid": 
            case "customerKeyId": {
                return this.getOrCreateConfiguration(target).getCustomerKeyId();
            }
            case "customerkeymd5": 
            case "customerKeyMD5": {
                return this.getOrCreateConfiguration(target).getCustomerKeyMD5();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return this.getOrCreateConfiguration(target).isDeleteAfterWrite();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return this.getOrCreateConfiguration(target).getDestinationBucket();
            }
            case "filename": 
            case "fileName": {
                return this.getOrCreateConfiguration(target).getFileName();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "includefolders": 
            case "includeFolders": {
                return this.getOrCreateConfiguration(target).isIncludeFolders();
            }
            case "keyname": 
            case "keyName": {
                return this.getOrCreateConfiguration(target).getKeyName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return this.getOrCreateConfiguration(target).isMoveAfterRead();
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return this.getOrCreateConfiguration(target).isMultiPartUpload();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "partsize": 
            case "partSize": {
                return this.getOrCreateConfiguration(target).getPartSize();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "useawskms": 
            case "useAwsKMS": {
                return this.getOrCreateConfiguration(target).isUseAwsKMS();
            }
            case "usecustomerkey": 
            case "useCustomerKey": {
                return this.getOrCreateConfiguration(target).isUseCustomerKey();
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                return this.getOrCreateConfiguration(target).isUseIAMCredentials();
            }
        }
        return null;
    }
}

