/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;

@UriParams
public class AWS2S3Configuration
implements Cloneable {
    private String bucketName;
    @UriParam
    private S3Client amazonS3Client;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam(label="consumer")
    private String fileName;
    @UriParam(label="consumer")
    private String prefix;
    @UriParam(label="consumer")
    private String delimiter;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeFolders = true;
    @UriParam
    private String region;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deleteAfterRead = true;
    @UriParam(label="consumer")
    private boolean moveAfterRead;
    @UriParam(label="consumer")
    private String destinationBucket;
    @UriParam(label="consumer")
    private String destinationBucketPrefix;
    @UriParam(label="consumer")
    private String destinationBucketSuffix;
    @UriParam(label="producer")
    private boolean deleteAfterWrite;
    @UriParam(label="producer")
    private boolean multiPartUpload;
    @UriParam(label="producer", defaultValue="26214400")
    private long partSize = 0x1900000L;
    @UriParam
    private String policy;
    @UriParam(label="producer")
    private String storageClass;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam
    private String proxyHost;
    @UriParam
    private Integer proxyPort;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeBody = true;
    @UriParam(label="producer", enums="copyObject,listObjects,deleteObject,deleteBucket,listBuckets,getObject,getObjectRange")
    private AWS2S3Operations operation;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean autocloseBody = true;
    @UriParam(label="common", defaultValue="true")
    private boolean autoCreateBucket = true;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useAwsKMS;
    @UriParam(label="producer,advanced")
    private String awsKMSKeyId;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useCustomerKey;
    @UriParam(label="common,advanced")
    private String customerKeyId;
    @UriParam(label="common,advanced")
    private String customerKeyMD5;
    @UriParam(label="common,advanced")
    private String customerAlgorithm;
    @UriParam(defaultValue="false")
    private boolean useIAMCredentials;
    @UriParam(label="producer")
    private String keyName;
    @UriParam(defaultValue="false")
    private boolean overrideEndpoint;
    @UriParam(defaultValue="false")
    private boolean trustAllCertificates;
    @UriParam
    private String uriEndpointOverride;
    @UriParam(defaultValue="false")
    private boolean pojoRequest;
    @UriParam(label="common", defaultValue="true")
    private boolean autoDiscoverClient = true;

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public boolean isMultiPartUpload() {
        return this.multiPartUpload;
    }

    public void setMultiPartUpload(boolean multiPartUpload) {
        this.multiPartUpload = multiPartUpload;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public S3Client getAmazonS3Client() {
        return this.amazonS3Client;
    }

    public void setAmazonS3Client(S3Client amazonS3Client) {
        this.amazonS3Client = amazonS3Client;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setIncludeBody(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public boolean isIncludeBody() {
        return this.includeBody;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public boolean isMoveAfterRead() {
        return this.moveAfterRead;
    }

    public void setMoveAfterRead(boolean moveAfterRead) {
        this.moveAfterRead = moveAfterRead;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public String getDestinationBucketPrefix() {
        return this.destinationBucketPrefix;
    }

    public void setDestinationBucketPrefix(String destinationBucketPrefix) {
        this.destinationBucketPrefix = destinationBucketPrefix;
    }

    public String getDestinationBucketSuffix() {
        return this.destinationBucketSuffix;
    }

    public void setDestinationBucketSuffix(String destinationBucketSuffix) {
        this.destinationBucketSuffix = destinationBucketSuffix;
    }

    public boolean isDeleteAfterWrite() {
        return this.deleteAfterWrite;
    }

    public void setDeleteAfterWrite(boolean deleteAfterWrite) {
        this.deleteAfterWrite = deleteAfterWrite;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public AWS2S3Operations getOperation() {
        return this.operation;
    }

    public void setOperation(AWS2S3Operations operation) {
        this.operation = operation;
    }

    public boolean isAutocloseBody() {
        return this.autocloseBody;
    }

    public void setAutocloseBody(boolean autocloseBody) {
        this.autocloseBody = autocloseBody;
    }

    public boolean isUseAwsKMS() {
        return this.useAwsKMS;
    }

    public void setUseAwsKMS(boolean useAwsKMS) {
        this.useAwsKMS = useAwsKMS;
    }

    public String getAwsKMSKeyId() {
        return this.awsKMSKeyId;
    }

    public void setAwsKMSKeyId(String awsKMSKeyId) {
        this.awsKMSKeyId = awsKMSKeyId;
    }

    public boolean isUseCustomerKey() {
        return this.useCustomerKey;
    }

    public void setUseCustomerKey(boolean useCustomerKey) {
        this.useCustomerKey = useCustomerKey;
    }

    public String getCustomerKeyId() {
        return this.customerKeyId;
    }

    public void setCustomerKeyId(String customerKeyId) {
        this.customerKeyId = customerKeyId;
    }

    public String getCustomerKeyMD5() {
        return this.customerKeyMD5;
    }

    public void setCustomerKeyMD5(String customerKeyMD5) {
        this.customerKeyMD5 = customerKeyMD5;
    }

    public String getCustomerAlgorithm() {
        return this.customerAlgorithm;
    }

    public void setCustomerAlgorithm(String customerAlgorithm) {
        this.customerAlgorithm = customerAlgorithm;
    }

    public void setUseIAMCredentials(Boolean useIAMCredentials) {
        this.useIAMCredentials = useIAMCredentials;
    }

    public Boolean isUseIAMCredentials() {
        return this.useIAMCredentials;
    }

    public boolean isAutoCreateBucket() {
        return this.autoCreateBucket;
    }

    public void setAutoCreateBucket(boolean autoCreateBucket) {
        this.autoCreateBucket = autoCreateBucket;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public boolean isOverrideEndpoint() {
        return this.overrideEndpoint;
    }

    public void setOverrideEndpoint(boolean overrideEndpoint) {
        this.overrideEndpoint = overrideEndpoint;
    }

    public String getUriEndpointOverride() {
        return this.uriEndpointOverride;
    }

    public void setUriEndpointOverride(String uriEndpointOverride) {
        this.uriEndpointOverride = uriEndpointOverride;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public AWS2S3Configuration copy() {
        try {
            return (AWS2S3Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

