/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AWS2S3Consumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Consumer.class);
    private String marker;
    private transient String s3ConsumerToString;

    public AWS2S3Consumer(AWS2S3Endpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        block4: {
            super.doStart();
            if (this.getConfiguration().isMoveAfterRead()) {
                try {
                    ListObjectsRequest.Builder builder = ListObjectsRequest.builder();
                    builder.bucket(this.getConfiguration().getDestinationBucket());
                    builder.maxKeys(Integer.valueOf(this.maxMessagesPerPoll));
                    this.getAmazonS3Client().listObjects((ListObjectsRequest)builder.build());
                    LOG.trace("Bucket [{}] already exists", (Object)this.getConfiguration().getDestinationBucket());
                    return;
                }
                catch (AwsServiceException ase) {
                    if (ase.awsErrorDetails().errorCode().equalsIgnoreCase("404")) {
                        throw ase;
                    }
                    LOG.trace("Destination Bucket [{}] doesn't exist yet", (Object)this.getConfiguration().getDestinationBucket());
                    if (!this.getConfiguration().isAutoCreateBucket()) break block4;
                    CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.getConfiguration().getDestinationBucket()).build();
                    LOG.trace("Creating Destination bucket [{}] in region [{}] with request [{}]...", new Object[]{this.getConfiguration().getDestinationBucket(), this.getConfiguration().getRegion(), createBucketRequest});
                    this.getAmazonS3Client().createBucket(createBucketRequest);
                    LOG.trace("Destination Bucket created");
                }
            }
        }
    }

    protected int poll() throws Exception {
        Queue<Exchange> exchanges;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String fileName = this.getConfiguration().getFileName();
        String bucketName = this.getConfiguration().getBucketName();
        if (fileName != null) {
            LOG.trace("Getting object in bucket [{}] with file name [{}]...", (Object)bucketName, (Object)fileName);
            ResponseInputStream s3Object = this.getAmazonS3Client().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(fileName).build());
            exchanges = this.createExchanges((ResponseInputStream<GetObjectResponse>)s3Object, fileName);
        } else {
            ListObjectsResponse listObjects;
            LOG.trace("Queueing objects in bucket [{}]...", (Object)bucketName);
            ListObjectsRequest.Builder listObjectsRequest = ListObjectsRequest.builder();
            listObjectsRequest.bucket(bucketName);
            listObjectsRequest.prefix(this.getConfiguration().getPrefix());
            listObjectsRequest.delimiter(this.getConfiguration().getDelimiter());
            if (this.maxMessagesPerPoll > 0) {
                listObjectsRequest.maxKeys(Integer.valueOf(this.maxMessagesPerPoll));
            }
            if (this.marker != null) {
                LOG.trace("Resuming from marker: {}", (Object)this.marker);
                listObjectsRequest.marker(this.marker);
            }
            if ((listObjects = this.getAmazonS3Client().listObjects((ListObjectsRequest)listObjectsRequest.build())).isTruncated().booleanValue()) {
                this.marker = listObjects.nextMarker();
                LOG.trace("Returned list is truncated, so setting next marker: {}", (Object)this.marker);
            } else {
                this.marker = null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} objects in bucket [{}]...", (Object)listObjects.contents().size(), (Object)bucketName);
            }
            exchanges = this.createExchanges(listObjects.contents());
        }
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(ResponseInputStream<GetObjectResponse> s3Object, String key) {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        Exchange exchange = this.getEndpoint().createExchange(s3Object, key);
        answer.add(exchange);
        return answer;
    }

    protected Queue<Exchange> createExchanges(List<S3Object> s3ObjectSummaries) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received {} messages in this poll", (Object)s3ObjectSummaries.size());
        }
        ArrayList<ResponseInputStream> s3Objects = new ArrayList<ResponseInputStream>();
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        try {
            for (S3Object s3ObjectSummary : s3ObjectSummaries) {
                ResponseInputStream s3Object;
                GetObjectRequest.Builder getRequest = GetObjectRequest.builder().bucket(this.getConfiguration().getBucketName()).key(s3ObjectSummary.key());
                if (this.getConfiguration().isUseCustomerKey()) {
                    if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyId())) {
                        getRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
                    }
                    if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerKeyMD5())) {
                        getRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
                    }
                    if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getCustomerAlgorithm())) {
                        getRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
                    }
                }
                if (!this.includeS3Object((ResponseInputStream<GetObjectResponse>)(s3Object = (ResponseInputStream)this.getAmazonS3Client().getObject((GetObjectRequest)getRequest.build(), ResponseTransformer.toInputStream())))) continue;
                s3Objects.add(s3Object);
                Exchange exchange = this.getEndpoint().createExchange((ResponseInputStream<GetObjectResponse>)s3Object, s3ObjectSummary.key());
                answer.add(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error getting S3Object due: {}", (Object)e.getMessage(), (Object)e);
            s3Objects.forEach(IOHelper::close);
            throw e;
        }
        return answer;
    }

    protected boolean includeS3Object(ResponseInputStream<GetObjectResponse> s3Object) {
        if (this.getConfiguration().isIncludeFolders()) {
            return true;
        }
        return !"application/x-directory".equalsIgnoreCase(((GetObjectResponse)s3Object.response()).contentType());
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    AWS2S3Consumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    AWS2S3Consumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "S3ConsumerOnCompletion";
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    LOG.trace("Processing exchange [{}] done.", (Object)exchange);
                }
            });
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            String key;
            String bucketName;
            if (this.getConfiguration().isMoveAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                LOG.trace("Moving object from bucket {} with key {} to bucket {}...", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket()});
                StringBuilder builder = new StringBuilder();
                if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getDestinationBucketPrefix())) {
                    builder.append(this.getConfiguration().getDestinationBucketPrefix());
                }
                builder.append(key);
                if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getDestinationBucketPrefix())) {
                    builder.append(this.getConfiguration().getDestinationBucketSuffix());
                }
                this.getAmazonS3Client().copyObject((CopyObjectRequest)CopyObjectRequest.builder().destinationKey(builder.toString()).destinationBucket(this.getConfiguration().getDestinationBucket()).copySource(bucketName + "/" + key).build());
                LOG.trace("Moved object from bucket {} with key {} to bucket {}...", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket()});
            }
            if (this.getConfiguration().isDeleteAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                LOG.trace("Deleting object from bucket {} with key {}...", (Object)bucketName, (Object)key);
                this.getAmazonS3Client().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.getConfiguration().getBucketName()).key(key).build());
                LOG.trace("Deleted object from bucket {} with key {}...", (Object)bucketName, (Object)key);
            }
        }
        catch (AwsServiceException e) {
            this.getExceptionHandler().handleException("Error occurred during moving or deleting object. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected S3Client getAmazonS3Client() {
        return this.getEndpoint().getS3Client();
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.s3ConsumerToString == null) {
            this.s3ConsumerToString = "S3Consumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ConsumerToString;
    }
}

