/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.util.Map;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Consumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;

public class AWS2S3ConsumerHealthCheck
extends AbstractHealthCheck {
    private final AWS2S3Consumer aws2S3Consumer;

    public AWS2S3ConsumerHealthCheck(AWS2S3Consumer aws2S3Consumer, String routeId) {
        super("camel", "aws2-s3-consumer-" + routeId);
        this.aws2S3Consumer = aws2S3Consumer;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try (S3Client client = this.aws2S3Consumer.getAmazonS3Client();){
            AWS2S3Configuration configuration = this.aws2S3Consumer.getConfiguration();
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !S3Client.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(configuration.getBucketName()).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

