/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;

public class Ses2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Ses2Producer.class);
    private transient String sesProducerToString;

    public Ses2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        if (!(exchange.getIn().getBody() instanceof javax.mail.Message)) {
            SendEmailRequest request = this.createMailRequest(exchange);
            LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendEmailResponse result = this.getEndpoint().getSESClient().sendEmail(request);
            LOG.trace("Received result [{}]", (Object)result);
            Message message = Ses2Producer.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.messageId());
        } else {
            SendRawEmailRequest request = this.createRawMailRequest(exchange);
            LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendRawEmailResponse result = this.getEndpoint().getSESClient().sendRawEmail(request);
            LOG.trace("Received result [{}]", (Object)result);
            Message message = Ses2Producer.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.messageId());
        }
    }

    private SendEmailRequest createMailRequest(Exchange exchange) {
        SendEmailRequest.Builder request = SendEmailRequest.builder();
        request.source(this.determineFrom(exchange));
        request.destination(this.determineDestination(exchange));
        request.returnPath(this.determineReturnPath(exchange));
        request.replyToAddresses(this.determineReplyToAddresses(exchange));
        request.message(this.createMessage(exchange));
        request.configurationSetName(this.determineConfigurationSet(exchange));
        return (SendEmailRequest)request.build();
    }

    private SendRawEmailRequest createRawMailRequest(Exchange exchange) throws Exception {
        SendRawEmailRequest.Builder request = SendRawEmailRequest.builder();
        request.source(this.determineFrom(exchange));
        request.destinations(this.determineRawTo(exchange));
        request.rawMessage(this.createRawMessage(exchange));
        request.configurationSetName(this.determineConfigurationSet(exchange));
        return (SendRawEmailRequest)request.build();
    }

    private software.amazon.awssdk.services.ses.model.Message createMessage(Exchange exchange) {
        Message.Builder message = software.amazon.awssdk.services.ses.model.Message.builder();
        Boolean isHtmlEmail = (Boolean)exchange.getIn().getHeader("CamelAwsSesHtmlEmail", (Object)false, Boolean.class);
        String content = (String)exchange.getIn().getBody(String.class);
        if (isHtmlEmail.booleanValue()) {
            message.body((Body)Body.builder().html((Content)Content.builder().data(content).build()).build());
        } else {
            message.body((Body)Body.builder().text((Content)Content.builder().data(content).build()).build());
        }
        message.subject((Content)Content.builder().data(this.determineSubject(exchange)).build());
        return (software.amazon.awssdk.services.ses.model.Message)message.build();
    }

    private RawMessage createRawMessage(Exchange exchange) throws Exception {
        RawMessage.Builder message = RawMessage.builder();
        javax.mail.Message content = (javax.mail.Message)exchange.getIn().getBody(javax.mail.Message.class);
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            content.writeTo((OutputStream)byteOutput);
        }
        catch (Exception e) {
            LOG.error("Cannot write to byte Array");
            throw e;
        }
        byte[] messageByteArray = byteOutput.toByteArray();
        message.data(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(messageByteArray)));
        return (RawMessage)message.build();
    }

    private Collection<String> determineReplyToAddresses(Exchange exchange) {
        String replyToAddresses = (String)exchange.getIn().getHeader("CamelAwsSesReplyToAddresses", String.class);
        if (replyToAddresses == null) {
            replyToAddresses = this.getConfiguration().getReplyToAddresses();
        }
        if (ObjectHelper.isNotEmpty((Object)replyToAddresses)) {
            return Stream.of(replyToAddresses.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String determineReturnPath(Exchange exchange) {
        String returnPath = (String)exchange.getIn().getHeader("CamelAwsSesReturnPath", String.class);
        if (returnPath == null) {
            returnPath = this.getConfiguration().getReturnPath();
        }
        return returnPath;
    }

    private Destination determineDestination(Exchange exchange) {
        List<String> to = this.determineRawTo(exchange);
        List<String> cc = this.determineRawCc(exchange);
        List<String> bcc = this.determineRawBcc(exchange);
        return (Destination)Destination.builder().toAddresses(to).ccAddresses(cc).bccAddresses(bcc).build();
    }

    private List<String> determineRawCc(Exchange exchange) {
        String cc = (String)exchange.getIn().getHeader("CamelAwsSesCc", String.class);
        if (ObjectHelper.isEmpty((Object)cc)) {
            cc = this.getConfiguration().getCc();
        }
        if (ObjectHelper.isNotEmpty((Object)cc)) {
            return Stream.of(cc.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> determineRawBcc(Exchange exchange) {
        String bcc = (String)exchange.getIn().getHeader("CamelAwsSesBcc", String.class);
        if (ObjectHelper.isEmpty((Object)bcc)) {
            bcc = this.getConfiguration().getBcc();
        }
        if (ObjectHelper.isNotEmpty((Object)bcc)) {
            return Stream.of(bcc.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> determineRawTo(Exchange exchange) {
        String to = (String)exchange.getIn().getHeader("CamelAwsSesTo", String.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        if (ObjectHelper.isNotEmpty((Object)to)) {
            return Stream.of(to.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String determineFrom(Exchange exchange) {
        String from = (String)exchange.getIn().getHeader("CamelAwsSesFrom", String.class);
        if (from == null) {
            from = this.getConfiguration().getFrom();
        }
        return from;
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSesSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    private String determineConfigurationSet(Exchange exchange) {
        String configuration = (String)exchange.getIn().getHeader("CamelAwsSesConfigurationSet", String.class);
        if (configuration == null) {
            configuration = this.getConfiguration().getConfigurationSet();
        }
        return configuration;
    }

    protected Ses2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.sesProducerToString == null) {
            this.sesProducerToString = "SesProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sesProducerToString;
    }

    public Ses2Endpoint getEndpoint() {
        return (Ses2Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

