/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.net.URI;
import java.util.HashMap;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.Sns2HeaderFilterStrategy;
import org.apache.camel.component.aws2.sns.Sns2Producer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.Topic;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-sns", title="AWS 2 Simple Notification System", syntax="aws2-sns:topicNameOrArn", producerOnly=true, label="cloud,mobile,messaging")
public class Sns2Endpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(Sns2Endpoint.class);
    private SnsClient snsClient;
    @UriPath(description="Topic name or ARN")
    @Metadata(required=true)
    private String topicNameOrArn;
    @UriParam
    private Sns2Configuration configuration;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public Sns2Endpoint(String uri, Component component, Sns2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Sns2Producer((Endpoint)this);
    }

    public void doInit() throws Exception {
        super.doInit();
        SnsClient snsClient = this.snsClient = this.configuration.getAmazonSNSClient() != null ? this.configuration.getAmazonSNSClient() : this.createSNSClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new Sns2HeaderFilterStrategy();
        }
        if (this.configuration.getTopicArn() == null) {
            try {
                String nextToken = null;
                String arnSuffix = ":" + this.configuration.getTopicName();
                block2: do {
                    ListTopicsRequest request = (ListTopicsRequest)ListTopicsRequest.builder().nextToken(nextToken).build();
                    ListTopicsResponse response = this.snsClient.listTopics(request);
                    nextToken = response.nextToken();
                    for (Topic topic : response.topics()) {
                        if (!topic.topicArn().endsWith(arnSuffix)) continue;
                        this.configuration.setTopicArn(topic.topicArn());
                        continue block2;
                    }
                } while (nextToken != null);
            }
            catch (AwsServiceException ase) {
                LOG.trace("The list topics operation return the following error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
        }
        if (this.configuration.getTopicArn() == null && this.configuration.isAutoCreateTopic()) {
            CreateTopicRequest.Builder builder = CreateTopicRequest.builder().name(this.configuration.getTopicName());
            if (this.configuration.isServerSideEncryptionEnabled() && ObjectHelper.isNotEmpty((Object)this.configuration.getKmsMasterKeyId())) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("KmsMasterKeyId", this.configuration.getKmsMasterKeyId());
                builder.attributes(attributes);
            }
            LOG.trace("Creating topic [{}] with request [{}]...", (Object)this.configuration.getTopicName(), (Object)builder);
            CreateTopicResponse result = this.snsClient.createTopic((CreateTopicRequest)builder.build());
            this.configuration.setTopicArn(result.topicArn());
            LOG.trace("Topic created with Amazon resource name: {}", (Object)this.configuration.getTopicArn());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getPolicy())) {
            LOG.trace("Updating topic [{}] with policy [{}]", (Object)this.configuration.getTopicArn(), (Object)this.configuration.getPolicy());
            this.snsClient.setTopicAttributes((SetTopicAttributesRequest)SetTopicAttributesRequest.builder().topicArn(this.configuration.getTopicArn()).attributeName("Policy").attributeValue(this.configuration.getPolicy()).build());
            LOG.trace("Topic policy updated");
        }
        if (this.configuration.isSubscribeSNStoSQS()) {
            if (ObjectHelper.isNotEmpty((Object)ObjectHelper.isNotEmpty((Object)this.configuration.getQueueUrl()))) {
                SubscribeResponse resp = this.snsClient.subscribe((SubscribeRequest)SubscribeRequest.builder().topicArn(this.configuration.getTopicArn()).protocol("sqs").endpoint(this.configuration.getQueueUrl()).returnSubscriptionArn(Boolean.valueOf(true)).build());
                LOG.trace("Subscription of SQS Queue to SNS Topic done with Amazon resource name: {}", (Object)resp.subscriptionArn());
            } else {
                throw new IllegalArgumentException("Using the SubscribeSNStoSQS option require both AmazonSQSClient and Queue URL options");
            }
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSNSClient()) && this.snsClient != null) {
            this.snsClient.close();
        }
        super.doStop();
    }

    public Sns2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sns2Configuration configuration) {
        this.configuration = configuration;
    }

    public void setSNSClient(SnsClient snsClient) {
        this.snsClient = snsClient;
    }

    public SnsClient getSNSClient() {
        return this.snsClient;
    }

    SnsClient createSNSClient() {
        SnsClient client = null;
        SnsClientBuilder clientBuilder = SnsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + this.configuration.getProxyHost() + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (SnsClientBuilder)((SnsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (SnsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (SnsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (SnsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (SnsClient)clientBuilder.build();
        return client;
    }
}

