/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Sns2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topicNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "aws2-sns".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "topicNameOrArn", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("serverSideEncryptionEnabled");
        props.add("autoCreateTopic");
        props.add("proxyProtocol");
        props.add("secretKey");
        props.add("subject");
        props.add("messageDeduplicationIdStrategy");
        props.add("subscribeSNStoSQS");
        props.add("uriEndpointOverride");
        props.add("queueUrl");
        props.add("messageStructure");
        props.add("useDefaultCredentialsProvider");
        props.add("proxyHost");
        props.add("trustAllCertificates");
        props.add("proxyPort");
        props.add("lazyStartProducer");
        props.add("messageGroupIdStrategy");
        props.add("headerFilterStrategy");
        props.add("accessKey");
        props.add("topicNameOrArn");
        props.add("overrideEndpoint");
        props.add("kmsMasterKeyId");
        props.add("region");
        props.add("amazonSNSClient");
        props.add("policy");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

