/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.sns.Sns2ComponentVerifierExtension;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.Sns2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

@org.apache.camel.spi.annotations.Component(value="aws2-sns")
public class Sns2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Sns2Component.class);
    @Metadata
    private Sns2Configuration configuration = new Sns2Configuration();

    public Sns2Component() {
        this(null);
    }

    public Sns2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Sns2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Topic name must be specified.");
        }
        if (this.containsTransientParameters(parameters)) {
            Map<String, Object> transientParameters = this.getTransientParameters(parameters);
            this.setProperties(this.getCamelContext(), (Object)this, transientParameters);
        }
        this.configuration = this.configuration != null ? this.configuration : new Sns2Configuration();
        Sns2Endpoint endpoint = new Sns2Endpoint(uri, (Component)this, this.configuration);
        Map<String, Object> nonTransientParameters = this.getNonTransientParameters(parameters);
        this.setProperties((Endpoint)endpoint, nonTransientParameters);
        if (remaining.startsWith("arn:")) {
            this.parseRemaining(remaining);
        } else {
            this.configuration.setTopicName(remaining);
            LOG.debug("Created the endpoint with topic {}", (Object)this.configuration.getTopicName());
        }
        if (this.configuration.getAmazonSNSClient() == null && (this.configuration.getAccessKey() == null || this.configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSNSClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    private boolean containsTransientParameters(Map<String, Object> parameters) {
        return parameters.containsKey("configuration");
    }

    private Map<String, Object> getNonTransientParameters(Map<String, Object> parameters) {
        return parameters.entrySet().stream().filter(k -> !((String)k.getKey()).equals("configuration")).collect(Collectors.toMap(k -> (String)k.getKey(), k -> k.getValue()));
    }

    private Map<String, Object> getTransientParameters(Map<String, Object> parameters) {
        return parameters.entrySet().stream().filter(k -> ((String)k.getKey()).equals("configuration")).collect(Collectors.toMap(k -> (String)k.getKey(), k -> k.getValue()));
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        super.validateParameters(uri, this.getNonTransientParameters(parameters), optionPrefix);
    }

    private void parseRemaining(String remaining) {
        String[] parts = remaining.split(":");
        if (parts.length != 6 || !parts[2].equals("sns")) {
            throw new IllegalArgumentException("Topic arn must be in format arn:aws:sns:region:account:name.");
        }
        this.configuration.setTopicArn(remaining);
        this.configuration.setRegion(Region.of((String)parts[3]).toString());
        LOG.debug("Created the endpoint with topic arn {}", (Object)this.configuration.getTopicArn());
    }

    public Sns2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sns2Configuration configuration) {
        this.configuration = configuration;
    }
}

