/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Endpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageNotInflightException;
import software.amazon.awssdk.services.sqs.model.QueueDeletedRecentlyException;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.ReceiptHandleIsInvalidException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SqsException;

public class Sqs2Consumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Consumer.class);
    private ScheduledExecutorService scheduledExecutor;
    private transient String sqsConsumerToString;
    private Collection<String> attributeNames;
    private Collection<String> messageAttributeNames;

    public Sqs2Consumer(Sqs2Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        String[] names;
        if (this.getConfiguration().getAttributeNames() != null) {
            names = this.getConfiguration().getAttributeNames().split(",");
            this.attributeNames = Arrays.asList(names);
        }
        if (this.getConfiguration().getMessageAttributeNames() != null) {
            names = this.getConfiguration().getMessageAttributeNames().split(",");
            this.messageAttributeNames = Arrays.asList(names);
        }
    }

    protected int poll() throws Exception {
        ReceiveMessageResponse messageResult;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        ReceiveMessageRequest.Builder request = ReceiveMessageRequest.builder().queueUrl(this.getQueueUrl());
        request.maxNumberOfMessages(this.getMaxMessagesPerPoll() > 0 ? Integer.valueOf(this.getMaxMessagesPerPoll()) : null);
        request.visibilityTimeout(this.getConfiguration().getVisibilityTimeout());
        request.waitTimeSeconds(this.getConfiguration().getWaitTimeSeconds());
        if (this.attributeNames != null) {
            request.attributeNamesWithStrings(this.attributeNames);
        }
        if (this.messageAttributeNames != null) {
            request.messageAttributeNames(this.messageAttributeNames);
        }
        LOG.trace("Receiving messages with request [{}]...", (Object)request);
        ReceiveMessageRequest requestBuild = (ReceiveMessageRequest)request.build();
        try {
            messageResult = this.getClient().receiveMessage(requestBuild);
        }
        catch (QueueDoesNotExistException e) {
            LOG.info("Queue does not exist....recreating now...");
            this.reConnectToQueue();
            messageResult = this.getClient().receiveMessage(requestBuild);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received {} messages", (Object)messageResult.messages().size());
        }
        Queue<Exchange> exchanges = this.createExchanges(messageResult.messages());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    public void reConnectToQueue() {
        try {
            if (this.getEndpoint().getConfiguration().isAutoCreateQueue()) {
                this.getEndpoint().createQueue(this.getClient());
            }
        }
        catch (QueueDeletedRecentlyException qdr) {
            LOG.debug("Queue recently deleted, will retry in 30 seconds.");
            try {
                Thread.sleep(30000L);
                this.getEndpoint().createQueue(this.getClient());
            }
            catch (Exception e) {
                LOG.warn("failed to retry queue connection.", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not connect to queue in amazon.", (Throwable)e);
        }
    }

    protected Queue<Exchange> createExchanges(List<software.amazon.awssdk.services.sqs.model.Message> messages) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received {} messages in this poll", (Object)messages.size());
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (software.amazon.awssdk.services.sqs.model.Message message : messages) {
            Exchange exchange = this.createExchange(message);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            Integer visibilityTimeout = this.getConfiguration().getVisibilityTimeout();
            if (this.scheduledExecutor != null && visibilityTimeout != null && visibilityTimeout / 2 > 0) {
                int delay = visibilityTimeout / 2;
                int period = visibilityTimeout;
                int repeatSeconds = Double.valueOf(visibilityTimeout.doubleValue() * 1.5).intValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduled TimeoutExtender task to start after {} delay, and run with {}/{} period/repeat (seconds), to extend exchangeId: {}", new Object[]{delay, period, repeatSeconds, exchange.getExchangeId()});
                }
                final ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(new TimeoutExtender(exchange, repeatSeconds), delay, period, TimeUnit.SECONDS);
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                    public void onComplete(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    public void onFailure(Exchange exchange) {
                        this.cancelExtender(exchange);
                    }

                    private void cancelExtender(Exchange exchange) {
                        LOG.trace("Processing done so cancelling TimeoutExtender task for exchangeId: {}", (Object)exchange.getExchangeId());
                        scheduledFuture.cancel(false);
                    }
                });
            }
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    Sqs2Consumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    Sqs2Consumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "SqsConsumerOnCompletion";
                }
            });
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.shouldDelete(exchange)) {
                String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
                DeleteMessageRequest.Builder deleteRequest = DeleteMessageRequest.builder().queueUrl(this.getQueueUrl()).receiptHandle(receiptHandle);
                LOG.trace("Deleting message with receipt handle {}...", (Object)receiptHandle);
                this.getClient().deleteMessage((DeleteMessageRequest)deleteRequest.build());
                LOG.trace("Deleted message with receipt handle {}...", (Object)receiptHandle);
            }
        }
        catch (AwsServiceException e) {
            this.getExceptionHandler().handleException("Error occurred during deleting message. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    private boolean shouldDelete(Exchange exchange) {
        boolean shouldDeleteByFilter = exchange.getProperty("CamelAwsSqsDeleteFiltered") != null && this.getConfiguration().isDeleteIfFiltered() && this.passedThroughFilter(exchange);
        return this.getConfiguration().isDeleteAfterRead() || shouldDeleteByFilter;
    }

    private boolean passedThroughFilter(Exchange exchange) {
        return (Boolean)exchange.getProperty("CamelAwsSqsDeleteFiltered", (Object)false, Boolean.class);
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, (Throwable)cause);
        }
    }

    protected Sqs2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected SqsClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public Sqs2Endpoint getEndpoint() {
        return (Sqs2Endpoint)super.getEndpoint();
    }

    public Exchange createExchange(software.amazon.awssdk.services.sqs.model.Message msg) {
        return this.createExchange(this.getEndpoint().getExchangePattern(), msg);
    }

    private Exchange createExchange(ExchangePattern pattern, software.amazon.awssdk.services.sqs.model.Message msg) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(pattern);
        Message message = exchange.getIn();
        message.setBody((Object)msg.body());
        message.setHeaders(new HashMap(msg.attributesAsStrings()));
        message.setHeader("CamelAwsSqsMessageId", (Object)msg.messageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)msg.md5OfBody());
        message.setHeader("CamelAwsSqsReceiptHandle", (Object)msg.receiptHandle());
        message.setHeader("CamelAwsSqsAttributes", (Object)msg.attributes());
        message.setHeader("CamelAwsSqsMessageAttributes", (Object)msg.messageAttributes());
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry entry : msg.messageAttributes().entrySet()) {
            Object value;
            String header = (String)entry.getKey();
            if (headerFilterStrategy.applyFilterToExternalHeaders(header, value = Sqs2Consumer.translateValue((MessageAttributeValue)entry.getValue()), exchange)) continue;
            message.setHeader(header, value);
        }
        return exchange;
    }

    private static Object translateValue(MessageAttributeValue mav) {
        String result = null;
        if (mav.stringValue() != null) {
            result = mav.stringValue();
        } else if (mav.binaryValue() != null) {
            result = mav.binaryValue();
        }
        return result;
    }

    public String toString() {
        if (this.sqsConsumerToString == null) {
            this.sqsConsumerToString = "SqsConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sqsConsumerToString;
    }

    protected void doStart() throws Exception {
        if (this.getConfiguration().isExtendMessageVisibility() && this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SqsTimeoutExtender");
        }
        super.doStart();
    }

    protected void doShutdown() throws Exception {
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
        super.doShutdown();
    }

    private class TimeoutExtender
    implements Runnable {
        private final Exchange exchange;
        private final int repeatSeconds;

        TimeoutExtender(Exchange exchange, int repeatSeconds) {
            this.exchange = exchange;
            this.repeatSeconds = repeatSeconds;
        }

        @Override
        public void run() {
            ChangeMessageVisibilityRequest.Builder request = ChangeMessageVisibilityRequest.builder().queueUrl(Sqs2Consumer.this.getQueueUrl()).visibilityTimeout(Integer.valueOf(this.repeatSeconds)).receiptHandle((String)this.exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class));
            try {
                LOG.trace("Extending visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
                Sqs2Consumer.this.getEndpoint().getClient().changeMessageVisibility((ChangeMessageVisibilityRequest)request.build());
                LOG.debug("Extended visibility window by {} seconds for exchange {}", (Object)this.repeatSeconds, (Object)this.exchange);
            }
            catch (ReceiptHandleIsInvalidException receiptHandleIsInvalidException) {
            }
            catch (MessageNotInflightException messageNotInflightException) {
            }
            catch (SqsException e) {
                if (!e.getMessage().contains("Message does not exist or is not available for visibility timeout change")) {
                    this.logException((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                this.logException(e);
            }
        }

        private void logException(Exception e) {
            LOG.warn("Extending visibility window failed for exchange " + this.exchange + ". Will not attempt to extend visibility further. This exception will be ignored.", (Throwable)e);
        }
    }
}

