/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spi.annotations.HealthCheck;
import org.apache.camel.support.service.ServiceSupport;

@HealthCheck(value="camel-aws2-sqs-repository")
@DeferredContextBinding
public class Sqs2HealthCheckRepository
extends ServiceSupport
implements CamelContextAware,
HealthCheckRepository,
StaticService,
NonManagedService {
    public static final String REPOSITORY_ID = "camel-aws2-sqs";
    private final List<org.apache.camel.health.HealthCheck> checks = new CopyOnWriteArrayList<org.apache.camel.health.HealthCheck>();
    private volatile CamelContext context;
    private boolean enabled = true;

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public String getId() {
        return REPOSITORY_ID;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Stream<org.apache.camel.health.HealthCheck> stream() {
        return this.context != null && this.enabled ? this.checks.stream() : Stream.empty();
    }

    public void addHealthCheck(org.apache.camel.health.HealthCheck healthCheck) {
        CamelContextAware.trySetCamelContext((Object)healthCheck, (CamelContext)this.getCamelContext());
        this.checks.add(healthCheck);
    }

    public void removeHealthCheck(org.apache.camel.health.HealthCheck healthCheck) {
        this.checks.remove(healthCheck);
    }
}

