/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.sqs.Sqs2Component;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.sqs.SqsClient;

public class Sqs2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Sqs2Configuration getOrCreateConfiguration(Sqs2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Sqs2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Sqs2Component target = (Sqs2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonawshost": 
            case "amazonAWSHost": {
                this.getOrCreateConfiguration(target).setAmazonAWSHost((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonsqsclient": 
            case "amazonSQSClient": {
                this.getOrCreateConfiguration(target).setAmazonSQSClient((SqsClient)Sqs2ComponentConfigurer.property((CamelContext)camelContext, SqsClient.class, (Object)value));
                return true;
            }
            case "attributenames": 
            case "attributeNames": {
                this.getOrCreateConfiguration(target).setAttributeNames((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autocreatequeue": 
            case "autoCreateQueue": {
                this.getOrCreateConfiguration(target).setAutoCreateQueue((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                this.getOrCreateConfiguration(target).setConcurrentConsumers((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Sqs2Configuration)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Sqs2Configuration.class, (Object)value));
                return true;
            }
            case "defaultvisibilitytimeout": 
            case "defaultVisibilityTimeout": {
                this.getOrCreateConfiguration(target).setDefaultVisibilityTimeout((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "delayqueue": 
            case "delayQueue": {
                this.getOrCreateConfiguration(target).setDelayQueue((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delayseconds": 
            case "delaySeconds": {
                this.getOrCreateConfiguration(target).setDelaySeconds((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteiffiltered": 
            case "deleteIfFiltered": {
                this.getOrCreateConfiguration(target).setDeleteIfFiltered((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "extendmessagevisibility": 
            case "extendMessageVisibility": {
                this.getOrCreateConfiguration(target).setExtendMessageVisibility((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kmsdatakeyreuseperiodseconds": 
            case "kmsDataKeyReusePeriodSeconds": {
                this.getOrCreateConfiguration(target).setKmsDataKeyReusePeriodSeconds((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "kmsmasterkeyid": 
            case "kmsMasterKeyId": {
                this.getOrCreateConfiguration(target).setKmsMasterKeyId((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maximummessagesize": 
            case "maximumMessageSize": {
                this.getOrCreateConfiguration(target).setMaximumMessageSize((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messageattributenames": 
            case "messageAttributeNames": {
                this.getOrCreateConfiguration(target).setMessageAttributeNames((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messagededuplicationidstrategy": 
            case "messageDeduplicationIdStrategy": {
                this.getOrCreateConfiguration(target).setMessageDeduplicationIdStrategy((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messagegroupidstrategy": 
            case "messageGroupIdStrategy": {
                this.getOrCreateConfiguration(target).setMessageGroupIdStrategy((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messageretentionperiod": 
            case "messageRetentionPeriod": {
                this.getOrCreateConfiguration(target).setMessageRetentionPeriod((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((Sqs2Operations)((Object)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Sqs2Operations.class, (Object)value)));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocol": {
                this.getOrCreateConfiguration(target).setProtocol((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "queueownerawsaccountid": 
            case "queueOwnerAWSAccountId": {
                this.getOrCreateConfiguration(target).setQueueOwnerAWSAccountId((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "queueurl": 
            case "queueUrl": {
                this.getOrCreateConfiguration(target).setQueueUrl((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "receivemessagewaittimeseconds": 
            case "receiveMessageWaitTimeSeconds": {
                this.getOrCreateConfiguration(target).setReceiveMessageWaitTimeSeconds((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "redrivepolicy": 
            case "redrivePolicy": {
                this.getOrCreateConfiguration(target).setRedrivePolicy((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Sqs2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryptionenabled": 
            case "serverSideEncryptionEnabled": {
                this.getOrCreateConfiguration(target).setServerSideEncryptionEnabled((Boolean)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                this.getOrCreateConfiguration(target).setVisibilityTimeout((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "waittimeseconds": 
            case "waitTimeSeconds": {
                this.getOrCreateConfiguration(target).setWaitTimeSeconds((Integer)Sqs2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonAWSHost", String.class);
        answer.put("amazonSQSClient", SqsClient.class);
        answer.put("attributeNames", String.class);
        answer.put("autoCreateQueue", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("concurrentConsumers", Integer.TYPE);
        answer.put("configuration", Sqs2Configuration.class);
        answer.put("defaultVisibilityTimeout", Integer.class);
        answer.put("delayQueue", Boolean.TYPE);
        answer.put("delaySeconds", Integer.class);
        answer.put("deleteAfterRead", Boolean.TYPE);
        answer.put("deleteIfFiltered", Boolean.TYPE);
        answer.put("extendMessageVisibility", Boolean.TYPE);
        answer.put("kmsDataKeyReusePeriodSeconds", Integer.class);
        answer.put("kmsMasterKeyId", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maximumMessageSize", Integer.class);
        answer.put("messageAttributeNames", String.class);
        answer.put("messageDeduplicationIdStrategy", String.class);
        answer.put("messageGroupIdStrategy", String.class);
        answer.put("messageRetentionPeriod", Integer.class);
        answer.put("operation", Sqs2Operations.class);
        answer.put("policy", String.class);
        answer.put("protocol", String.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("queueOwnerAWSAccountId", String.class);
        answer.put("queueUrl", String.class);
        answer.put("receiveMessageWaitTimeSeconds", Integer.class);
        answer.put("redrivePolicy", String.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("serverSideEncryptionEnabled", Boolean.TYPE);
        answer.put("visibilityTimeout", Integer.class);
        answer.put("waitTimeSeconds", Integer.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Sqs2Component target = (Sqs2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonawshost": 
            case "amazonAWSHost": {
                return this.getOrCreateConfiguration(target).getAmazonAWSHost();
            }
            case "amazonsqsclient": 
            case "amazonSQSClient": {
                return this.getOrCreateConfiguration(target).getAmazonSQSClient();
            }
            case "attributenames": 
            case "attributeNames": {
                return this.getOrCreateConfiguration(target).getAttributeNames();
            }
            case "autocreatequeue": 
            case "autoCreateQueue": {
                return this.getOrCreateConfiguration(target).isAutoCreateQueue();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return this.getOrCreateConfiguration(target).getConcurrentConsumers();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "defaultvisibilitytimeout": 
            case "defaultVisibilityTimeout": {
                return this.getOrCreateConfiguration(target).getDefaultVisibilityTimeout();
            }
            case "delayqueue": 
            case "delayQueue": {
                return this.getOrCreateConfiguration(target).isDelayQueue();
            }
            case "delayseconds": 
            case "delaySeconds": {
                return this.getOrCreateConfiguration(target).getDelaySeconds();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteiffiltered": 
            case "deleteIfFiltered": {
                return this.getOrCreateConfiguration(target).isDeleteIfFiltered();
            }
            case "extendmessagevisibility": 
            case "extendMessageVisibility": {
                return this.getOrCreateConfiguration(target).isExtendMessageVisibility();
            }
            case "kmsdatakeyreuseperiodseconds": 
            case "kmsDataKeyReusePeriodSeconds": {
                return this.getOrCreateConfiguration(target).getKmsDataKeyReusePeriodSeconds();
            }
            case "kmsmasterkeyid": 
            case "kmsMasterKeyId": {
                return this.getOrCreateConfiguration(target).getKmsMasterKeyId();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maximummessagesize": 
            case "maximumMessageSize": {
                return this.getOrCreateConfiguration(target).getMaximumMessageSize();
            }
            case "messageattributenames": 
            case "messageAttributeNames": {
                return this.getOrCreateConfiguration(target).getMessageAttributeNames();
            }
            case "messagededuplicationidstrategy": 
            case "messageDeduplicationIdStrategy": {
                return this.getOrCreateConfiguration(target).getMessageDeduplicationIdStrategy();
            }
            case "messagegroupidstrategy": 
            case "messageGroupIdStrategy": {
                return this.getOrCreateConfiguration(target).getMessageGroupIdStrategy();
            }
            case "messageretentionperiod": 
            case "messageRetentionPeriod": {
                return this.getOrCreateConfiguration(target).getMessageRetentionPeriod();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "protocol": {
                return this.getOrCreateConfiguration(target).getProtocol();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "queueownerawsaccountid": 
            case "queueOwnerAWSAccountId": {
                return this.getOrCreateConfiguration(target).getQueueOwnerAWSAccountId();
            }
            case "queueurl": 
            case "queueUrl": {
                return this.getOrCreateConfiguration(target).getQueueUrl();
            }
            case "receivemessagewaittimeseconds": 
            case "receiveMessageWaitTimeSeconds": {
                return this.getOrCreateConfiguration(target).getReceiveMessageWaitTimeSeconds();
            }
            case "redrivepolicy": 
            case "redrivePolicy": {
                return this.getOrCreateConfiguration(target).getRedrivePolicy();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "serversideencryptionenabled": 
            case "serverSideEncryptionEnabled": {
                return this.getOrCreateConfiguration(target).isServerSideEncryptionEnabled();
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                return this.getOrCreateConfiguration(target).getVisibilityTimeout();
            }
            case "waittimeseconds": 
            case "waitTimeSeconds": {
                return this.getOrCreateConfiguration(target).getWaitTimeSeconds();
            }
        }
        return null;
    }
}

