/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.sqs.NullMessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Component;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Consumer;
import org.apache.camel.component.aws2.sqs.Sqs2HeaderFilterStrategy;
import org.apache.camel.component.aws2.sqs.Sqs2Producer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultScheduledPollConsumerScheduler;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-sqs", title="AWS 2 Simple Queue Service", syntax="aws2-sqs:queueNameOrArn", label="cloud,messaging")
public class Sqs2Endpoint
extends ScheduledPollEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2Endpoint.class);
    private SqsClient client;
    private String queueUrl;
    @UriPath(description="Queue name or ARN")
    @Metadata(required=true)
    private String queueNameOrArn;
    @UriParam
    private Sqs2Configuration configuration;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public Sqs2Endpoint(String uri, Sqs2Component component, Sqs2Configuration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Producer createProducer() throws Exception {
        return new Sqs2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Sqs2Consumer sqsConsumer = new Sqs2Consumer(this, processor);
        this.configureConsumer((Consumer)sqsConsumer);
        sqsConsumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        DefaultScheduledPollConsumerScheduler scheduler = new DefaultScheduledPollConsumerScheduler();
        scheduler.setDelay(sqsConsumer.getDelay());
        scheduler.setUseFixedDelay(sqsConsumer.isUseFixedDelay());
        scheduler.setInitialDelay(sqsConsumer.getInitialDelay());
        scheduler.setTimeUnit(sqsConsumer.getTimeUnit());
        scheduler.setConcurrentTasks(this.configuration.getConcurrentConsumers());
        sqsConsumer.setScheduler((ScheduledPollConsumerScheduler)scheduler);
        return sqsConsumer;
    }

    private String getFullyQualifiedAWSHost() {
        String host = this.configuration.getAmazonAWSHost();
        if ((host = FileUtil.stripTrailingSeparator((String)host)).equals("amazonaws.com")) {
            return "sqs." + Region.of((String)this.configuration.getRegion()).id() + "." + host;
        }
        return host;
    }

    protected void doInit() throws Exception {
        super.doInit();
        SqsClient sqsClient = this.client = this.getConfiguration().getAmazonSQSClient() != null ? this.getConfiguration().getAmazonSQSClient() : this.getClient();
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new Sqs2HeaderFilterStrategy();
        }
        if (this.configuration.getQueueUrl() != null) {
            this.queueUrl = this.configuration.getQueueUrl();
        } else if (this.configuration.getRegion() != null && this.configuration.getQueueOwnerAWSAccountId() != null) {
            String protocol = this.configuration.getProtocol();
            this.queueUrl = protocol + "://" + this.getFullyQualifiedAWSHost() + "/" + this.configuration.getQueueOwnerAWSAccountId() + "/" + this.configuration.getQueueName();
        } else if (this.configuration.getQueueOwnerAWSAccountId() != null) {
            GetQueueUrlRequest.Builder getQueueUrlRequest = GetQueueUrlRequest.builder();
            getQueueUrlRequest.queueName(this.configuration.getQueueName());
            getQueueUrlRequest.queueOwnerAWSAccountId(this.configuration.getQueueOwnerAWSAccountId());
            GetQueueUrlResponse getQueueUrlResult = this.client.getQueueUrl((GetQueueUrlRequest)getQueueUrlRequest.build());
            this.queueUrl = getQueueUrlResult.queueUrl();
        } else {
            ListQueuesResponse listQueuesResult = this.client.listQueues();
            for (String url : listQueuesResult.queueUrls()) {
                if (!url.endsWith("/" + this.configuration.getQueueName())) continue;
                this.queueUrl = url;
                LOG.trace("Queue available at '{}'.", (Object)this.queueUrl);
                break;
            }
        }
        if (this.queueUrl == null && this.configuration.isAutoCreateQueue()) {
            this.createQueue(this.client);
        } else {
            LOG.debug("Using Amazon SQS queue url: {}", (Object)this.queueUrl);
            this.updateQueueAttributes(this.client);
        }
    }

    protected void createQueue(SqsClient client) {
        LOG.trace("Queue '{}' doesn't exist. Will create it...", (Object)this.configuration.getQueueName());
        CreateQueueRequest.Builder request = CreateQueueRequest.builder().queueName(this.configuration.getQueueName());
        HashMap<QueueAttributeName, String> attributes = new HashMap<QueueAttributeName, String>();
        if (this.getConfiguration().isFifoQueue()) {
            attributes.put(QueueAttributeName.FIFO_QUEUE, String.valueOf(true));
            boolean useContentBasedDeduplication = this.getConfiguration().getMessageDeduplicationIdStrategy() instanceof NullMessageDeduplicationIdStrategy;
            attributes.put(QueueAttributeName.CONTENT_BASED_DEDUPLICATION, String.valueOf(useContentBasedDeduplication));
        }
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            attributes.put(QueueAttributeName.VISIBILITY_TIMEOUT, String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            attributes.put(QueueAttributeName.MAXIMUM_MESSAGE_SIZE, String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            attributes.put(QueueAttributeName.MESSAGE_RETENTION_PERIOD, String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            attributes.put(QueueAttributeName.POLICY, String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            attributes.put(QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS, String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getDelaySeconds() != null && this.getConfiguration().isDelayQueue()) {
            attributes.put(QueueAttributeName.DELAY_SECONDS, String.valueOf(this.getConfiguration().getDelaySeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            attributes.put(QueueAttributeName.REDRIVE_POLICY, this.getConfiguration().getRedrivePolicy());
        }
        if (this.getConfiguration().isServerSideEncryptionEnabled()) {
            if (this.getConfiguration().getKmsMasterKeyId() != null) {
                attributes.put(QueueAttributeName.KMS_MASTER_KEY_ID, this.getConfiguration().getKmsMasterKeyId());
            }
            if (this.getConfiguration().getKmsDataKeyReusePeriodSeconds() != null) {
                attributes.put(QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS, String.valueOf(this.getConfiguration().getKmsDataKeyReusePeriodSeconds()));
            }
        }
        LOG.trace("Creating queue [{}] with request [{}]...", (Object)this.configuration.getQueueName(), (Object)request);
        request.attributes(attributes);
        CreateQueueResponse queueResult = client.createQueue((CreateQueueRequest)request.build());
        this.queueUrl = queueResult.queueUrl();
        LOG.trace("Queue created and available at: {}", (Object)this.queueUrl);
    }

    private void updateQueueAttributes(SqsClient client) {
        SetQueueAttributesRequest.Builder request = SetQueueAttributesRequest.builder().queueUrl(this.queueUrl);
        HashMap<QueueAttributeName, String> attributes = new HashMap<QueueAttributeName, String>();
        if (this.getConfiguration().getDefaultVisibilityTimeout() != null) {
            attributes.put(QueueAttributeName.VISIBILITY_TIMEOUT, String.valueOf(this.getConfiguration().getDefaultVisibilityTimeout()));
        }
        if (this.getConfiguration().getMaximumMessageSize() != null) {
            attributes.put(QueueAttributeName.MAXIMUM_MESSAGE_SIZE, String.valueOf(this.getConfiguration().getMaximumMessageSize()));
        }
        if (this.getConfiguration().getMessageRetentionPeriod() != null) {
            attributes.put(QueueAttributeName.MESSAGE_RETENTION_PERIOD, String.valueOf(this.getConfiguration().getMessageRetentionPeriod()));
        }
        if (this.getConfiguration().getPolicy() != null) {
            attributes.put(QueueAttributeName.POLICY, String.valueOf(this.getConfiguration().getPolicy()));
        }
        if (this.getConfiguration().getReceiveMessageWaitTimeSeconds() != null) {
            attributes.put(QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS, String.valueOf(this.getConfiguration().getReceiveMessageWaitTimeSeconds()));
        }
        if (this.getConfiguration().getDelaySeconds() != null && this.getConfiguration().isDelayQueue()) {
            attributes.put(QueueAttributeName.DELAY_SECONDS, String.valueOf(this.getConfiguration().getDelaySeconds()));
        }
        if (this.getConfiguration().getRedrivePolicy() != null) {
            attributes.put(QueueAttributeName.REDRIVE_POLICY, this.getConfiguration().getRedrivePolicy());
        }
        if (this.getConfiguration().isServerSideEncryptionEnabled()) {
            if (this.getConfiguration().getKmsMasterKeyId() != null) {
                attributes.put(QueueAttributeName.KMS_MASTER_KEY_ID, this.getConfiguration().getKmsMasterKeyId());
            }
            if (this.getConfiguration().getKmsDataKeyReusePeriodSeconds() != null) {
                attributes.put(QueueAttributeName.KMS_DATA_KEY_REUSE_PERIOD_SECONDS, String.valueOf(this.getConfiguration().getKmsDataKeyReusePeriodSeconds()));
            }
        }
        if (!attributes.isEmpty()) {
            request.attributes(attributes);
            LOG.trace("Updating queue '{}' with the provided queue attributes...", (Object)this.configuration.getQueueName());
            client.setQueueAttributes((SetQueueAttributesRequest)request.build());
            LOG.trace("Queue '{}' updated and available at {}'", (Object)this.configuration.getQueueName(), (Object)this.queueUrl);
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSQSClient()) && this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    public Exchange createExchange(software.amazon.awssdk.services.sqs.model.Message msg) {
        return this.createExchange(this.getExchangePattern(), msg);
    }

    private Exchange createExchange(ExchangePattern pattern, software.amazon.awssdk.services.sqs.model.Message msg) {
        Exchange exchange = super.createExchange(pattern);
        Message message = exchange.getIn();
        message.setBody((Object)msg.body());
        message.setHeaders(new HashMap(msg.attributesAsStrings()));
        message.setHeader("CamelAwsSqsMessageId", (Object)msg.messageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)msg.md5OfBody());
        message.setHeader("CamelAwsSqsReceiptHandle", (Object)msg.receiptHandle());
        message.setHeader("CamelAwsSqsAttributes", (Object)msg.attributes());
        message.setHeader("CamelAwsSqsMessageAttributes", (Object)msg.messageAttributes());
        HeaderFilterStrategy headerFilterStrategy = this.getHeaderFilterStrategy();
        for (Map.Entry entry : msg.messageAttributes().entrySet()) {
            Object value;
            String header = (String)entry.getKey();
            if (headerFilterStrategy.applyFilterToExternalHeaders(header, value = this.translateValue((MessageAttributeValue)entry.getValue()), exchange)) continue;
            message.setHeader(header, value);
        }
        return exchange;
    }

    public Sqs2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sqs2Configuration configuration) {
        this.configuration = configuration;
    }

    public SqsClient getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public void setClient(SqsClient client) {
        this.client = client;
    }

    SqsClient createClient() {
        SqsClient client = null;
        SqsClientBuilder clientBuilder = SqsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (SqsClientBuilder)((SqsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (SqsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (SqsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (SqsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (SqsClient)clientBuilder.build();
        return client;
    }

    protected String getQueueUrl() {
        return this.queueUrl;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    private Object translateValue(MessageAttributeValue mav) {
        String result = null;
        if (mav.stringValue() != null) {
            result = mav.stringValue();
        } else if (mav.binaryValue() != null) {
            result = mav.binaryValue();
        }
        return result;
    }
}

