/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs.client;

import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.client.Sqs2InternalClient;
import org.apache.camel.component.aws2.sqs.client.impl.Sqs2ClientIAMOptimized;
import org.apache.camel.component.aws2.sqs.client.impl.Sqs2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.sqs.client.impl.Sqs2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.sqs.client.impl.Sqs2ClientStandardImpl;

public final class Sqs2ClientFactory {
    private Sqs2ClientFactory() {
    }

    public static Sqs2InternalClient getSqsClient(Sqs2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Sqs2ClientIAMOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Sqs2ClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new Sqs2ClientSessionTokenImpl(configuration);
        }
        return new Sqs2ClientStandardImpl(configuration);
    }
}

