/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Sqs2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":queueNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "aws2-sqs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "queueNameOrArn", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(67);
        props.add("accessKey");
        props.add("amazonAWSHost");
        props.add("amazonSQSClient");
        props.add("attributeNames");
        props.add("autoCreateQueue");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("batchSeparator");
        props.add("bridgeErrorHandler");
        props.add("concurrentConsumers");
        props.add("defaultVisibilityTimeout");
        props.add("delay");
        props.add("delayQueue");
        props.add("delaySeconds");
        props.add("deleteAfterRead");
        props.add("deleteIfFiltered");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("extendMessageVisibility");
        props.add("greedy");
        props.add("headerFilterStrategy");
        props.add("initialDelay");
        props.add("kmsDataKeyReusePeriodSeconds");
        props.add("kmsMasterKeyId");
        props.add("lazyStartProducer");
        props.add("maxMessagesPerPoll");
        props.add("maximumMessageSize");
        props.add("messageAttributeNames");
        props.add("messageDeduplicationIdStrategy");
        props.add("messageGroupIdStrategy");
        props.add("messageHeaderExceededLimit");
        props.add("messageRetentionPeriod");
        props.add("operation");
        props.add("overrideEndpoint");
        props.add("policy");
        props.add("pollStrategy");
        props.add("profileCredentialsName");
        props.add("protocol");
        props.add("proxyHost");
        props.add("proxyPort");
        props.add("proxyProtocol");
        props.add("queueNameOrArn");
        props.add("queueOwnerAWSAccountId");
        props.add("queueUrl");
        props.add("receiveMessageWaitTimeSeconds");
        props.add("redrivePolicy");
        props.add("region");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("secretKey");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serverSideEncryptionEnabled");
        props.add("sessionToken");
        props.add("startScheduler");
        props.add("timeUnit");
        props.add("trustAllCertificates");
        props.add("uriEndpointOverride");
        props.add("useDefaultCredentialsProvider");
        props.add("useFixedDelay");
        props.add("useProfileCredentialsProvider");
        props.add("useSessionCredentials");
        props.add("visibilityTimeout");
        props.add("waitTimeSeconds");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("accessKey");
        secretProps.add("queueOwnerAWSAccountId");
        secretProps.add("secretKey");
        secretProps.add("sessionToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

