/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sts;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.sts.STS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sts.StsClient;

@org.apache.camel.spi.annotations.Component(value="aws2-sts")
public class STS2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(STS2Component.class);
    @Metadata
    private STS2Configuration configuration = new STS2Configuration();

    public STS2Component() {
        this(null);
    }

    public STS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new STS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        STS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new STS2Configuration();
        STS2Endpoint endpoint = new STS2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration, endpoint);
        }
        if (configuration.getStsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon STS client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public STS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(STS2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(STS2Configuration configuration, STS2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getStsClient())) {
            LOG.debug("Looking for an StsClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(StsClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one StsClient instance in the registry");
                configuration.setStsClient((StsClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No StsClient instance in the registry");
            }
        } else {
            LOG.debug("StsClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

