/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sts;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

@UriEndpoint(firstVersion="3.5.0", scheme="aws2-sts", title="AWS 2 Security Token Service (STS)", syntax="aws2-sts:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class STS2Endpoint
extends DefaultEndpoint {
    private StsClient stsClient;
    @UriParam
    private STS2Configuration configuration;

    public STS2Endpoint(String uri, Component component, STS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new STS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.stsClient = this.configuration.getStsClient() != null ? this.configuration.getStsClient() : this.createStsClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getStsClient()) && this.stsClient != null) {
            this.stsClient.close();
        }
        super.doStop();
    }

    public STS2Configuration getConfiguration() {
        return this.configuration;
    }

    public StsClient getStsClient() {
        return this.stsClient;
    }

    StsClient createStsClient() {
        StsClient client = null;
        StsClientBuilder clientBuilder = StsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (StsClientBuilder)((StsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (StsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (StsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (StsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (StsClient)clientBuilder.build();
        return client;
    }
}

