/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sts;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Endpoint;
import org.apache.camel.component.aws2.sts.STS2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;

public class STS2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(STS2Producer.class);
    private transient String stsProducerToString;

    public STS2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case assumeRole: {
                this.assumeRole(this.getEndpoint().getStsClient(), exchange);
                break;
            }
            case getSessionToken: {
                this.getSessionToken(this.getEndpoint().getStsClient(), exchange);
                break;
            }
            case getFederationToken: {
                this.getFederationToken(this.getEndpoint().getStsClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private STS2Operations determineOperation(Exchange exchange) {
        STS2Operations operation = (STS2Operations)((Object)exchange.getIn().getHeader("CamelAwsStsOperation", STS2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected STS2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.stsProducerToString == null) {
            this.stsProducerToString = "STSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.stsProducerToString;
    }

    public STS2Endpoint getEndpoint() {
        return (STS2Endpoint)super.getEndpoint();
    }

    private void assumeRole(StsClient stsClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof AssumeRoleRequest) {
                AssumeRoleResponse result;
                try {
                    AssumeRoleRequest request = (AssumeRoleRequest)payload;
                    result = stsClient.assumeRole(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Assume Role command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = STS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            AssumeRoleResponse result;
            AssumeRoleRequest.Builder builder = AssumeRoleRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStsRoleArn"))) {
                throw new IllegalArgumentException("Role ARN needs to be specified for assumeRole operation");
            }
            String roleArn = (String)exchange.getIn().getHeader("CamelAwsStsRoleArn", String.class);
            builder.roleArn(roleArn);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStsRoleSessionName"))) {
                throw new IllegalArgumentException("Role Session Name needs to be specified for assumeRole operation");
            }
            String roleSessionName = (String)exchange.getIn().getHeader("CamelAwsStsRoleSessionName", String.class);
            builder.roleSessionName(roleSessionName);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStsAssumeRoleDurationSeconds"))) {
                Integer durationInSeconds = (Integer)exchange.getIn().getHeader("CamelAwsStsAssumeRoleDurationSeconds", Integer.class);
                builder.durationSeconds(durationInSeconds);
            }
            try {
                result = stsClient.assumeRole((AssumeRoleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Assume Role command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = STS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getSessionToken(StsClient stsClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetSessionTokenRequest) {
                GetSessionTokenResponse result;
                try {
                    GetSessionTokenRequest request = (GetSessionTokenRequest)payload;
                    result = stsClient.getSessionToken(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Session Token command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = STS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetSessionTokenResponse result;
            GetSessionTokenRequest.Builder builder = GetSessionTokenRequest.builder();
            try {
                result = stsClient.getSessionToken((GetSessionTokenRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Session Token command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = STS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getFederationToken(StsClient stsClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetFederationTokenRequest) {
                GetFederationTokenResponse result;
                try {
                    GetFederationTokenRequest request = (GetFederationTokenRequest)payload;
                    result = stsClient.getFederationToken(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Federation Token command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = STS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetFederationTokenResponse result;
            GetFederationTokenRequest.Builder builder = GetFederationTokenRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStsFederatedName"))) {
                throw new IllegalArgumentException("Federated name needs to be specified for assumeRole operation");
            }
            String federatedName = (String)exchange.getIn().getHeader("CamelAwsStsFederatedName", String.class);
            builder.name(federatedName);
            try {
                result = stsClient.getFederationToken((GetFederationTokenRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Federation Token command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = STS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

