/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.write;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.timestream.Timestream2AbstractEndpoint;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.client.Timestream2ClientFactory;
import org.apache.camel.component.aws2.timestream.write.Timestream2WriteProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;

public class Timestream2WriteEndpoint
extends Timestream2AbstractEndpoint
implements EndpointServiceLocation {
    private TimestreamWriteClient awsTimestreamWriteClient;

    public Timestream2WriteEndpoint(String uri, Component component, Timestream2Configuration configuration) {
        super(uri, component, configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Timestream2WriteProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsTimestreamWriteClient = this.getConfiguration().getAwsTimestreamWriteClient() != null ? this.getConfiguration().getAwsTimestreamWriteClient() : Timestream2ClientFactory.getTimestreamClient(this.getConfiguration()).getTimestreamWriteClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getConfiguration().getAwsTimestreamWriteClient()) && this.awsTimestreamWriteClient != null) {
            this.awsTimestreamWriteClient.close();
        }
        super.doStop();
    }

    public TimestreamWriteClient getAwsTimestreamWriteClient() {
        return this.awsTimestreamWriteClient;
    }

    public String getServiceUrl() {
        if (!this.getConfiguration().isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getRegion())) {
                return this.getConfiguration().getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getUriEndpointOverride())) {
            return this.getConfiguration().getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "timestream-write";
    }
}

