/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.translate;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.translate.Translate2Configuration;
import org.apache.camel.component.aws2.translate.Translate2Producer;
import org.apache.camel.component.aws2.translate.client.Translate2ClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.translate.TranslateClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-translate", title="AWS Translate", syntax="aws2-translate:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class Translate2Endpoint
extends ScheduledPollEndpoint {
    private TranslateClient translateClient;
    @UriParam
    private Translate2Configuration configuration;

    public Translate2Endpoint(String uri, Component component, Translate2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Translate2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.translateClient = this.configuration.getTranslateClient() != null ? this.configuration.getTranslateClient() : Translate2ClientFactory.getTranslateClient(this.configuration).getTranslateClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTranslateClient()) && this.translateClient != null) {
            this.translateClient.close();
        }
        super.doStop();
    }

    public Translate2Configuration getConfiguration() {
        return this.configuration;
    }

    public TranslateClient getTranslateClient() {
        return this.translateClient;
    }
}

