/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.translate;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.translate.Translate2ComponentVerifierExtension;
import org.apache.camel.component.aws2.translate.Translate2Configuration;
import org.apache.camel.component.aws2.translate.Translate2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-translate")
public class Translate2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Translate2Component.class);
    @Metadata
    private Translate2Configuration configuration = new Translate2Configuration();

    public Translate2Component() {
        this(null);
    }

    public Translate2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Translate2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Translate2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Translate2Configuration();
        Translate2Endpoint endpoint = new Translate2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getTranslateClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon translate client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Translate2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Translate2Configuration configuration) {
        this.configuration = configuration;
    }
}

