/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.ThroughputResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfigurationOptionsProxy;
import org.apache.camel.component.azure.cosmosdb.CosmosDbEndpoint;
import org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition;
import org.apache.camel.component.azure.cosmosdb.client.CosmosAsyncClientWrapper;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbClientOperations;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbContainerOperations;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbDatabaseOperations;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbOperationsBuilder;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CosmosDbProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CosmosDbProducer.class);
    private CosmosAsyncClientWrapper clientWrapper;
    private CosmosDbConfigurationOptionsProxy configurationOptionsProxy;
    private final Map<CosmosDbOperationsDefinition, BiConsumer<Exchange, AsyncCallback>> operations = new HashMap<CosmosDbOperationsDefinition, BiConsumer<Exchange, AsyncCallback>>();

    public CosmosDbProducer(Endpoint endpoint) {
        super(endpoint);
        this.bind(CosmosDbOperationsDefinition.listDatabases, this.listDatabases());
        this.bind(CosmosDbOperationsDefinition.createDatabase, this.createDatabase());
        this.bind(CosmosDbOperationsDefinition.queryDatabases, this.queryDatabases());
        this.bind(CosmosDbOperationsDefinition.deleteDatabase, this.deleteDatabase());
        this.bind(CosmosDbOperationsDefinition.createContainer, this.createContainer());
        this.bind(CosmosDbOperationsDefinition.listContainers, this.listContainers());
        this.bind(CosmosDbOperationsDefinition.queryContainers, this.queryContainers());
        this.bind(CosmosDbOperationsDefinition.replaceDatabaseThroughput, this.replaceDatabaseThroughput());
        this.bind(CosmosDbOperationsDefinition.deleteContainer, this.deleteContainer());
        this.bind(CosmosDbOperationsDefinition.replaceContainerThroughput, this.replaceContainerThroughput());
        this.bind(CosmosDbOperationsDefinition.createItem, this.createItem());
        this.bind(CosmosDbOperationsDefinition.upsertItem, this.upsertItem());
        this.bind(CosmosDbOperationsDefinition.deleteItem, this.deleteItem());
        this.bind(CosmosDbOperationsDefinition.replaceItem, this.replaceItem());
        this.bind(CosmosDbOperationsDefinition.readItem, this.readItem());
        this.bind(CosmosDbOperationsDefinition.readAllItems, this.readAllItems());
        this.bind(CosmosDbOperationsDefinition.queryItems, this.queryItems());
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.clientWrapper = new CosmosAsyncClientWrapper(this.getEndpoint().getCosmosAsyncClient());
        this.configurationOptionsProxy = new CosmosDbConfigurationOptionsProxy(this.getConfiguration());
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.invokeOperation(this.configurationOptionsProxy.getOperation(exchange), exchange, callback);
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    public CosmosDbEndpoint getEndpoint() {
        return (CosmosDbEndpoint)super.getEndpoint();
    }

    private void bind(CosmosDbOperationsDefinition operation, BiConsumer<Exchange, AsyncCallback> fn) {
        this.operations.put(operation, fn);
    }

    private void invokeOperation(CosmosDbOperationsDefinition operation, Exchange exchange, AsyncCallback callback) {
        CosmosDbOperationsDefinition operationsToInvoke = ObjectHelper.isEmpty((Object)((Object)operation)) ? CosmosDbOperationsDefinition.listDatabases : operation;
        BiConsumer<Exchange, AsyncCallback> fnToInvoke = this.operations.get((Object)operationsToInvoke);
        if (fnToInvoke == null) {
            throw new RuntimeCamelException("Operation not supported. Value: " + (Object)((Object)operationsToInvoke));
        }
        fnToInvoke.accept(exchange, callback);
    }

    private CosmosDbConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private BiConsumer<Exchange, AsyncCallback> listDatabases() {
        return (exchange, callback) -> {
            Mono operation = CosmosDbClientOperations.withClient(this.clientWrapper).readAllDatabases().collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> createDatabase() {
        return (exchange, callback) -> {
            Mono<CosmosDatabaseResponse> operation = CosmosDbClientOperations.withClient(this.clientWrapper).createDatabase(this.configurationOptionsProxy.getDatabaseName((Exchange)exchange), this.configurationOptionsProxy.getThroughputProperties((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosDatabaseResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> queryDatabases() {
        return (exchange, callback) -> {
            Mono operation = CosmosDbClientOperations.withClient(this.clientWrapper).queryDatabases(this.configurationOptionsProxy.getQuery((Exchange)exchange), this.configurationOptionsProxy.getQueryRequestOptions((Exchange)exchange)).collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> deleteDatabase() {
        return (exchange, callback) -> {
            Mono<CosmosDatabaseResponse> operation = CosmosDbClientOperations.withClient(this.clientWrapper).getDatabaseOperations(this.configurationOptionsProxy.getDatabaseName((Exchange)exchange)).deleteDatabase(this.configurationOptionsProxy.getCosmosDatabaseRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosDatabaseResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> createContainer() {
        return (exchange, callback) -> {
            Mono<CosmosContainerResponse> operation = this.getDatabaseOperations((Exchange)exchange).createContainer(this.configurationOptionsProxy.getContainerName((Exchange)exchange), this.configurationOptionsProxy.getContainerPartitionKeyPath((Exchange)exchange), this.configurationOptionsProxy.getThroughputProperties((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosContainerResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> replaceDatabaseThroughput() {
        return (exchange, callback) -> {
            Mono<ThroughputResponse> operation = this.getDatabaseOperations((Exchange)exchange).replaceDatabaseThroughput(this.configurationOptionsProxy.getThroughputProperties((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setThroughputResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> listContainers() {
        return (exchange, callback) -> {
            Mono operation = this.getDatabaseOperations((Exchange)exchange).readAllContainers(this.configurationOptionsProxy.getQueryRequestOptions((Exchange)exchange)).collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> queryContainers() {
        return (exchange, callback) -> {
            Mono operation = this.getDatabaseOperations((Exchange)exchange).queryContainers(this.configurationOptionsProxy.getQuery((Exchange)exchange), this.configurationOptionsProxy.getQueryRequestOptions((Exchange)exchange)).collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> deleteContainer() {
        return (exchange, callback) -> {
            Mono<CosmosContainerResponse> operation = CosmosDbClientOperations.withClient(this.clientWrapper).getDatabaseOperations(this.configurationOptionsProxy.getDatabaseName((Exchange)exchange)).getContainerOperations(this.configurationOptionsProxy.getContainerName((Exchange)exchange)).deleteContainer(this.configurationOptionsProxy.getContainerRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosContainerResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> replaceContainerThroughput() {
        return (exchange, callback) -> {
            Mono<ThroughputResponse> operation = this.getContainerOperations((Exchange)exchange).replaceContainerThroughput(this.configurationOptionsProxy.getThroughputProperties((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setThroughputResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> createItem() {
        return (exchange, callback) -> {
            Mono<CosmosItemResponse<Object>> operation = this.getContainerOperations((Exchange)exchange).createItem(this.configurationOptionsProxy.getItem((Exchange)exchange), this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getItemRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosItemResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> upsertItem() {
        return (exchange, callback) -> {
            Mono<CosmosItemResponse<Object>> operation = this.getContainerOperations((Exchange)exchange).upsertItem(this.configurationOptionsProxy.getItem((Exchange)exchange), this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getItemRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosItemResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> deleteItem() {
        return (exchange, callback) -> {
            Mono<CosmosItemResponse<Object>> operation = this.getDatabaseOperations((Exchange)exchange).getContainerOperations(this.configurationOptionsProxy.getContainerName((Exchange)exchange)).deleteItem(this.configurationOptionsProxy.getItemId((Exchange)exchange), this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getItemRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosItemResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> replaceItem() {
        return (exchange, callback) -> {
            Mono<CosmosItemResponse<Object>> operation = this.getContainerOperations((Exchange)exchange).replaceItem(this.configurationOptionsProxy.getItem((Exchange)exchange), this.configurationOptionsProxy.getItemId((Exchange)exchange), this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getItemRequestOptions((Exchange)exchange));
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosItemResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> readItem() {
        return (exchange, callback) -> {
            Mono<CosmosItemResponse<Object>> operation = this.getContainerOperations((Exchange)exchange).readItem(this.configurationOptionsProxy.getItemId((Exchange)exchange), this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getItemRequestOptions((Exchange)exchange), Object.class);
            this.subscribeToMono((Mono)operation, (Exchange)exchange, this.setCosmosItemResponseOnExchange((Exchange)exchange), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> readAllItems() {
        return (exchange, callback) -> {
            Mono operation = this.getContainerOperations((Exchange)exchange).readAllItems(this.configurationOptionsProxy.getItemPartitionKey((Exchange)exchange), this.configurationOptionsProxy.getQueryRequestOptions((Exchange)exchange), Object.class).collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private BiConsumer<Exchange, AsyncCallback> queryItems() {
        return (exchange, callback) -> {
            Mono operation = this.getContainerOperations((Exchange)exchange).queryItems(this.configurationOptionsProxy.getQuery((Exchange)exchange), this.configurationOptionsProxy.getQueryRequestOptions((Exchange)exchange), Object.class).collectList();
            this.subscribeToMono((Mono)operation, (Exchange)exchange, results -> this.setMessageBody((Exchange)exchange, results), (AsyncCallback)callback);
        };
    }

    private <T> void subscribeToMono(Mono<T> inputMono, Exchange exchange, Consumer<T> resultsCallback, AsyncCallback callback) {
        inputMono.subscribe(resultsCallback, error -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error processing async exchange with error: {}", (Object)error.getMessage());
            }
            exchange.setException(error);
            callback.done(false);
        }, () -> {
            LOG.trace("All events with exchange have been sent successfully.");
            callback.done(false);
        });
    }

    private CosmosDbContainerOperations getContainerOperations(Exchange exchange) {
        return CosmosDbOperationsBuilder.withClient(this.clientWrapper).withDatabaseName(this.configurationOptionsProxy.getDatabaseName(exchange)).withCreateDatabaseIfNotExist(this.configurationOptionsProxy.isCreateDatabaseIfNotExist(exchange)).withThroughputProperties(this.configurationOptionsProxy.getThroughputProperties(exchange)).withContainerName(this.configurationOptionsProxy.getContainerName(exchange)).withContainerPartitionKeyPath(this.configurationOptionsProxy.getContainerPartitionKeyPath(exchange)).withCreateContainerIfNotExist(this.configurationOptionsProxy.isCreateContainerIfNotExist(exchange)).buildContainerOperations();
    }

    private CosmosDbDatabaseOperations getDatabaseOperations(Exchange exchange) {
        return CosmosDbOperationsBuilder.withClient(this.clientWrapper).withDatabaseName(this.configurationOptionsProxy.getDatabaseName(exchange)).withCreateDatabaseIfNotExist(this.configurationOptionsProxy.isCreateDatabaseIfNotExist(exchange)).withThroughputProperties(this.configurationOptionsProxy.getThroughputProperties(exchange)).buildDatabaseOperations();
    }

    private Consumer<CosmosDatabaseResponse> setCosmosDatabaseResponseOnExchange(Exchange exchange) {
        return response -> {
            if (ObjectHelper.isNotEmpty((Object)response.getProperties())) {
                this.setMessageHeader(exchange, "CamelAzureCosmosDbRecourseId", response.getProperties().getResourceId());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbEtag", response.getProperties().getETag());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbTimestamp", response.getProperties().getTimestamp());
            }
            this.setCommonResponseOnExchange(exchange, (CosmosResponse)response);
        };
    }

    private Consumer<CosmosContainerResponse> setCosmosContainerResponseOnExchange(Exchange exchange) {
        return response -> {
            if (ObjectHelper.isNotEmpty((Object)response.getProperties())) {
                this.setMessageHeader(exchange, "CamelAzureCosmosDbRecourseId", response.getProperties().getResourceId());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbEtag", response.getProperties().getETag());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbTimestamp", response.getProperties().getTimestamp());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbDefaultTimeToLiveInSeconds", response.getProperties().getDefaultTimeToLiveInSeconds());
            }
            this.setCommonResponseOnExchange(exchange, (CosmosResponse)response);
        };
    }

    private Consumer<ThroughputResponse> setThroughputResponseOnExchange(Exchange exchange) {
        return response -> {
            if (ObjectHelper.isNotEmpty((Object)response.getProperties())) {
                this.setMessageHeader(exchange, "CamelAzureCosmosDbAutoscaleMaxThroughput", response.getProperties().getAutoscaleMaxThroughput());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbManualThroughput", response.getProperties().getManualThroughput());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbEtag", response.getProperties().getETag());
                this.setMessageHeader(exchange, "CamelAzureCosmosDbTimestamp", response.getProperties().getTimestamp());
            }
            this.setCommonResponseOnExchange(exchange, (CosmosResponse)response);
        };
    }

    private <T> Consumer<CosmosItemResponse<T>> setCosmosItemResponseOnExchange(Exchange exchange) {
        return response -> {
            this.setMessageHeader(exchange, "CamelAzureCosmosDbEtag", response.getETag());
            this.setMessageHeader(exchange, "CamelAzureCosmosDbResponseHeaders", response.getResponseHeaders());
            this.setMessageHeader(exchange, "CamelAzureCosmosDbStatusCode", response.getStatusCode());
            this.setMessageBody(exchange, response.getItem());
        };
    }

    private <T> void setCommonResponseOnExchange(Exchange exchange, CosmosResponse<T> response) {
        this.setMessageHeader(exchange, "CamelAzureCosmosDbResponseHeaders", response.getResponseHeaders());
        this.setMessageHeader(exchange, "CamelAzureCosmosDbStatusCode", response.getStatusCode());
    }

    private void setMessageBody(Exchange exchange, Object body) {
        exchange.getMessage().setBody(body);
    }

    private void setMessageHeader(Exchange exchange, String headerKey, Object headerValue) {
        exchange.getMessage().setHeader(headerKey, headerValue);
    }
}

