/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.operations;

import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ThroughputProperties;
import org.apache.camel.component.azure.cosmosdb.CosmosDbUtils;
import org.apache.camel.component.azure.cosmosdb.client.CosmosAsyncClientWrapper;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbDatabaseOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CosmosDbClientOperations {
    public static final String PARAM_DATABASE_NAME = "databaseName";
    private final CosmosAsyncClientWrapper client;

    private CosmosDbClientOperations(CosmosAsyncClientWrapper client) {
        this.client = client;
    }

    public static CosmosDbClientOperations withClient(CosmosAsyncClientWrapper client) {
        return new CosmosDbClientOperations(client);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String databaseName, ThroughputProperties throughputProperties) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(databaseName, PARAM_DATABASE_NAME);
        return this.client.createDatabaseIfNotExists(databaseName, throughputProperties);
    }

    public CosmosDbDatabaseOperations createDatabaseIfNotExistAndGetDatabaseOperations(String databaseName, ThroughputProperties throughputProperties) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(databaseName, PARAM_DATABASE_NAME);
        return new CosmosDbDatabaseOperations(this.getAndCreateDatabaseIfNotExist(databaseName, true, throughputProperties));
    }

    public CosmosDbDatabaseOperations getDatabaseOperations(String databaseName) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(databaseName, PARAM_DATABASE_NAME);
        return new CosmosDbDatabaseOperations(this.getAndCreateDatabaseIfNotExist(databaseName, false, null));
    }

    public Flux<CosmosDatabaseProperties> readAllDatabases() {
        return CosmosDbUtils.convertCosmosPagedFluxToFluxResults(this.client.readAllDatabases());
    }

    public Flux<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions queryRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(query, "query");
        return CosmosDbUtils.convertCosmosPagedFluxToFluxResults(this.client.queryDatabases(query, queryRequestOptions));
    }

    private Mono<CosmosAsyncDatabase> getAndCreateDatabaseIfNotExist(String databaseName, boolean createDatabaseIfNotExist, ThroughputProperties throughputProperties) {
        if (createDatabaseIfNotExist) {
            return this.createDatabase(databaseName, throughputProperties).map(response -> this.getDatabase(databaseName));
        }
        return Mono.just((Object)this.getDatabase(databaseName));
    }

    private CosmosAsyncDatabase getDatabase(String databaseName) {
        return this.client.getDatabase(databaseName);
    }
}

