/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition;
import org.apache.camel.util.ObjectHelper;

public class CosmosDbConfigurationOptionsProxy {
    private final CosmosDbConfiguration configuration;

    public CosmosDbConfigurationOptionsProxy(CosmosDbConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getDatabaseName(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbDatabaseName", this.configuration::getDatabaseName, String.class);
    }

    public ThroughputProperties getThroughputProperties(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbThroughputProperties", this.configuration::getThroughputProperties, ThroughputProperties.class);
    }

    public CosmosDatabaseRequestOptions getCosmosDatabaseRequestOptions(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbDatabaseRequestOptions", this.nullFallback(), CosmosDatabaseRequestOptions.class);
    }

    public CosmosQueryRequestOptions getQueryRequestOptions(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbQueryRequestOptions", this.configuration::getQueryRequestOptions, CosmosQueryRequestOptions.class);
    }

    public boolean isCreateDatabaseIfNotExist(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbCreateDatabaseIfNotExist", this.configuration::isCreateDatabaseIfNotExists, Boolean.TYPE);
    }

    public boolean isCreateContainerIfNotExist(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbCreateContainerIfNotExist", this.configuration::isCreateContainerIfNotExists, Boolean.TYPE);
    }

    public CosmosDbOperationsDefinition getOperation(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbOperation", this.configuration::getOperation, CosmosDbOperationsDefinition.class);
    }

    public String getQuery(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbQuery", this.configuration::getQuery, String.class);
    }

    public String getContainerName(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbContainerName", this.configuration::getContainerName, String.class);
    }

    public String getContainerPartitionKeyPath(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbContainerPartitionKeyPath", this.configuration::getContainerPartitionKeyPath, String.class);
    }

    public IndexingPolicy getIndexingPolicy(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbIndexingPolicy", this.configuration::getIndexingPolicy, IndexingPolicy.class);
    }

    public CosmosContainerRequestOptions getContainerRequestOptions(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbContainerRequestOptions", this.nullFallback(), CosmosContainerRequestOptions.class);
    }

    public PartitionKey getItemPartitionKey(Exchange exchange) {
        return new PartitionKey((Object)this.getOption(exchange, "CamelAzureCosmosDbItemPartitionKey", this.configuration::getItemPartitionKey, String.class));
    }

    public Object getItem(Exchange exchange) {
        return exchange.getIn().getBody();
    }

    public List<Object> getItems(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            throw new IllegalArgumentException("Item on the message body cannot be empty.");
        }
        List<Object> items = null;
        items = body instanceof List ? (List<Object>)body : Collections.singletonList(body);
        return items;
    }

    public String getItemId(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbItemId", this.configuration::getItemId, String.class);
    }

    public CosmosItemRequestOptions getItemRequestOptions(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureCosmosDbItemRequestOptions", this.nullFallback(), CosmosItemRequestOptions.class);
    }

    public CosmosDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public <R> Supplier<R> nullFallback() {
        return () -> null;
    }

    private <R> R getOption(Exchange exchange, String headerName, Supplier<R> fallbackFn, Class<R> type) {
        return ObjectHelper.isEmpty((Object)exchange) || ObjectHelper.isEmpty(CosmosDbConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type)) ? fallbackFn.get() : CosmosDbConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type);
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)exchange.getIn().getHeader(headerName, classType);
    }
}

