/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-cosmosdb:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure CosmosDB Change Feed processor response details")
public class CosmosDbCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.cosmosdb.changes");
        headers.put("CamelCloudEventSource", "org.apache.camel.event.azure.cosmosdb.changefeed");
        headers.put("CamelCloudEventSubject", "org.apache.camel.event.azure.cosmosdb.changefeed");
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "text/plain");
    }
}

